/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.network.iprange;

import host.anzo.commons.network.iprange.IPRange;
import java.io.IOException;
import java.net.InetAddress;
import org.jetbrains.annotations.NotNull;

public class IP4Range
implements IPRange {
    private final long baseAddress;
    private final long mask;

    public IP4Range(@NotNull String ipWithPrefix) throws IOException {
        String[] parts = ipWithPrefix.split("/");
        String baseAddress = parts[0];
        int prefixLength = Integer.parseInt(parts[1]);
        this.baseAddress = this.ipToLong(InetAddress.getByName(baseAddress).getAddress());
        this.mask = -1L << 32 - prefixLength;
    }

    private long ipToLong(byte @NotNull [] ipAddress) {
        long result = 0L;
        for (byte octet : ipAddress) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    @Override
    public boolean contains(@NotNull InetAddress address) {
        long ip = this.ipToLong(address.getAddress());
        return (ip & this.mask) == (this.baseAddress & this.mask);
    }
}

