package host.anzo.commons.threading;

import lombok.Getter;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author ANZO
 * @since 8/19/2021
 */
public class ThreadPoolPriorityFactory implements ThreadFactory {
    private final int priority;
    private final String name;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final @Getter ThreadGroup group;

    public ThreadPoolPriorityFactory(String name, int priority) {
        this.priority = priority;
        this.name = name;
        group = new ThreadGroup(this.name);
    }

    @Override
    public Thread newThread(@NotNull Runnable runnable) {
        final Thread thread = new Thread(group, runnable, name + "-" + threadNumber.getAndIncrement());
        thread.setPriority(priority);
        return thread;
    }
}