package host.anzo.commons.network.iprange;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.net.InetAddress;

/**
 * @author Aristo
 */
public class IP4Range implements IPRange {
    private final long baseAddress;
    private final long mask;

    public IP4Range(@NotNull String ipWithPrefix) throws IOException {
        String[] parts = ipWithPrefix.split("/");
        String baseAddress = parts[0];
        int prefixLength = Integer.parseInt(parts[1]);
        this.baseAddress = ipToLong(InetAddress.getByName(baseAddress).getAddress());
        this.mask = -1L << (32 - prefixLength);
    }

    private long ipToLong(byte @NotNull [] ipAddress) {
        long result = 0;
        for (byte octet : ipAddress) {
            result <<= 8;
            result |= octet & 0xff;
        }
        return result;
    }

    @Override
    public boolean contains(@NotNull InetAddress address) {
        final long ip = ipToLong(address.getAddress());
        return (ip & mask) == (baseAddress & mask);
    }
}