package host.anzo.commons.collection;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * @author ANZO
 * @since 9/20/2021
 */
public class ConcurrentHashSet<E> extends AbstractSet<E> implements Set<E> {
    private final ConcurrentMap<E, Object> map;

    private static final Object EMPTY_OBJECT = new Object();

    public ConcurrentHashSet(){
        map = new ConcurrentHashMap<>();
    }

    @Override
    public int size() {
        return map.size();
    }

    @Override
    public Iterator<E> iterator(){
        return map.keySet().iterator();
    }

    @Override
    public boolean isEmpty(){
        return map.isEmpty();
    }

    @Override
    public boolean add(final E o){
        return map.put(o, ConcurrentHashSet.EMPTY_OBJECT) == null;
    }

    @Override
    public boolean contains(final Object o){
        return map.containsKey(o);
    }

    @Override
    public void clear(){
        map.clear();
    }

    @Override
    public boolean remove(final Object o){
        return map.remove(o) == ConcurrentHashSet.EMPTY_OBJECT;
    }

    public boolean addIfAbsent(final E o){
        final Object obj = map.putIfAbsent(o, ConcurrentHashSet.EMPTY_OBJECT);
        return obj == null;
    }
}
