package host.anzo.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author xTz, ANZO
 */
public class ListSplitter<T> {
	private List<T> objects;
	private int splitCount;
	private int currentIndex = 0;

	public ListSplitter(Collection<T> collection, int splitCount) {
		if (collection != null) {
			this.splitCount = splitCount;
			this.objects = new ArrayList<>(collection);
		}
	}

	public List<T> getNext(int splitCount) {
		this.splitCount = splitCount;
		return getNext();
	}

	public List<T> getNext() {
		final int chunkSize = Math.min(splitCount, objects.size() - currentIndex);
		final List<T> chunk = objects.subList(currentIndex, currentIndex + chunkSize);
		currentIndex += chunkSize;
		return chunk;
	}

	public int size() {
		return objects.size();
	}

	public boolean isFirst() {
		return currentIndex <= splitCount;
	}

	public boolean isLast() {
		return currentIndex == objects.size();
	}
	
	public boolean hasNext() {
		return currentIndex < objects.size();
	}
}