/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import host.anzo.core.service.CloudflareService;
import host.anzo.core.service.HttpService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import org.eclipse.jetty.websocket.api.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;

public class IpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final Pattern VALID_IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static String EXTERNAL_IP = null;

    @Nullable
    public static String getExternalIP() {
        if (IpUtils.checkIPv4(EXTERNAL_IP)) {
            return EXTERNAL_IP;
        }
        String ip = HttpService.getInstance().httpGet("https://api.ipify.org/");
        if (!IpUtils.checkIPv4(ip)) {
            ip = HttpService.getInstance().httpGet("http://ipinfo.io/ip");
        }
        if (!IpUtils.checkIPv4(ip)) {
            ip = HttpService.getInstance().httpGet("https://www.trackip.net/ip");
        }
        if (!IpUtils.checkIPv4(ip)) {
            ip = HttpService.getInstance().httpGet("http://checkip.amazonaws.com/");
        }
        if (IpUtils.checkIPv4(ip)) {
            EXTERNAL_IP = ip;
            return ip;
        }
        return null;
    }

    public static boolean isLocalAddress(@NotNull InetAddress address) {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(address) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static long getPing(@NotNull InetAddress address) {
        try {
            long startTime = System.nanoTime();
            boolean status = address.isReachable(1000);
            if (status) {
                return TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static boolean checkIPv4(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        return VALID_IPV4_PATTERN.matcher(ip).matches();
    }

    public static String getRealIp(@NotNull Request request) {
        String realIp;
        if (CloudflareService.getInstance().isCloudflareIP(request.ip()) && (realIp = request.headers("CF-Connecting-IP")) != null) {
            return realIp;
        }
        return request.ip();
    }

    public static String getRealIp(@NotNull Session session) {
        String cloudflareTunnelIp = session.getUpgradeRequest().getHeader("Cf-Connecting-Ip");
        if (cloudflareTunnelIp != null) {
            return cloudflareTunnelIp;
        }
        return ((InetSocketAddress)session.getRemoteAddress()).getHostString();
    }

    public static long toLong(@NotNull String ip) {
        try {
            String[] octets = ip.split("\\.");
            int[] octetsNum = new int[]{Integer.parseInt(octets[0]), Integer.parseInt(octets[1]), Integer.parseInt(octets[2]), Integer.parseInt(octets[3])};
            return (long)octetsNum[0] * (long)((int)Math.pow(256.0, 3.0)) + (long)octetsNum[1] * (long)((int)Math.pow(256.0, 2.0)) + (long)octetsNum[2] * 256L + (long)octetsNum[3];
        }
        catch (Exception e) {
            log.error("Can't parse ip=[{}] to long", (Object)ip);
            return 0L;
        }
    }

    @NotNull
    public static String fromLong(long ipLong) {
        return (ipLong >> 24 & 0xFFL) + "." + (ipLong >> 16 & 0xFFL) + "." + (ipLong >> 8 & 0xFFL) + "." + (ipLong & 0xFFL);
    }
}

