/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.config;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import host.anzo.commons.utils.MathUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTypeCaster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigTypeCaster.class);

    public static void cast(Object object, @NotNull Field field, String value, String splitter, Long minValue, Long maxValue) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        block12: {
            Class type;
            block34: {
                String[] values;
                block33: {
                    String[] values2;
                    block32: {
                        String[] values3;
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                block21: {
                                                                    block20: {
                                                                        block19: {
                                                                            block18: {
                                                                                block17: {
                                                                                    block16: {
                                                                                        block15: {
                                                                                            block14: {
                                                                                                block13: {
                                                                                                    block11: {
                                                                                                        if (!field.trySetAccessible()) {
                                                                                                            throw new RuntimeException("Can't set accessible flag for field [" + field.getName() + "] at object [" + String.valueOf(object) + "]");
                                                                                                        }
                                                                                                        type = field.getType();
                                                                                                        if (!type.isEnum()) break block11;
                                                                                                        if (StringUtils.isNumeric((CharSequence)value)) {
                                                                                                            field.set(object, field.getType().getEnumConstants()[Integer.parseInt(value)]);
                                                                                                        } else {
                                                                                                            field.set(object, Enum.valueOf(type, value));
                                                                                                        }
                                                                                                        break block12;
                                                                                                    }
                                                                                                    if (type != Integer.class && type != Integer.TYPE) break block13;
                                                                                                    field.set(object, MathUtils.clamp(Integer.decode(value), Ints.saturatedCast((long)minValue), Ints.saturatedCast((long)maxValue)));
                                                                                                    break block12;
                                                                                                }
                                                                                                if (type != Short.class && type != Short.TYPE) break block14;
                                                                                                field.set(object, MathUtils.clamp(Short.decode(value), Shorts.saturatedCast((long)minValue), Shorts.saturatedCast((long)maxValue)));
                                                                                                break block12;
                                                                                            }
                                                                                            if (type != Float.class && type != Float.TYPE) break block15;
                                                                                            field.set(object, MathUtils.clamp(Float.valueOf(Float.parseFloat(value)), Float.valueOf(minValue.floatValue()), Float.valueOf(maxValue.floatValue())));
                                                                                            break block12;
                                                                                        }
                                                                                        if (type != Double.class && type != Double.TYPE) break block16;
                                                                                        field.set(object, MathUtils.clamp(Double.parseDouble(value), minValue.doubleValue(), maxValue.doubleValue()));
                                                                                        break block12;
                                                                                    }
                                                                                    if (type != Long.class && type != Long.TYPE) break block17;
                                                                                    field.set(object, MathUtils.clamp(Long.decode(value), minValue, maxValue));
                                                                                    break block12;
                                                                                }
                                                                                if (type != Boolean.class && type != Boolean.TYPE) break block18;
                                                                                if (NumberUtils.isDigits((String)value)) {
                                                                                    field.set(object, value.equals("1"));
                                                                                } else {
                                                                                    field.set(object, Boolean.parseBoolean(value));
                                                                                }
                                                                                break block12;
                                                                            }
                                                                            if (type != String.class) break block19;
                                                                            field.set(object, value);
                                                                            break block12;
                                                                        }
                                                                        if (type != Character.class && type != Character.TYPE) break block20;
                                                                        field.set(object, Character.valueOf(value.charAt(0)));
                                                                        break block12;
                                                                    }
                                                                    if (type != Byte.class && type != Byte.TYPE) break block21;
                                                                    field.set(object, Byte.parseByte(value));
                                                                    break block12;
                                                                }
                                                                if (type != AtomicInteger.class) break block22;
                                                                field.set(object, new AtomicInteger(Integer.decode(value)));
                                                                break block12;
                                                            }
                                                            if (type != AtomicBoolean.class) break block23;
                                                            field.set(object, new AtomicBoolean(Boolean.parseBoolean(value)));
                                                            break block12;
                                                        }
                                                        if (type != AtomicLong.class) break block24;
                                                        field.set(object, new AtomicLong(Long.decode(value)));
                                                        break block12;
                                                    }
                                                    if (type != BigInteger.class) break block25;
                                                    field.set(object, new BigInteger(value));
                                                    break block12;
                                                }
                                                if (type != BigDecimal.class) break block26;
                                                field.set(object, new BigDecimal(value));
                                                break block12;
                                            }
                                            if (type != Path.class) break block27;
                                            field.set(object, Paths.get(value, new String[0]));
                                            break block12;
                                        }
                                        if (type != Pattern.class) break block28;
                                        field.set(object, Pattern.compile(value));
                                        break block12;
                                    }
                                    if (type != Duration.class) break block29;
                                    field.set(object, Duration.parse(value));
                                    break block12;
                                }
                                if (type != UUID.class) break block30;
                                field.set(object, UUID.fromString(value));
                                break block12;
                            }
                            if (!type.isArray()) break block31;
                            if (value == null) break block12;
                            String[] values4 = value.split(splitter);
                            Class<?> baseType = field.getType().getComponentType();
                            Object array = Array.newInstance(baseType, values4.length);
                            field.set(object, array);
                            int index = 0;
                            for (String arrValue : values4) {
                                Object objectValue = ConfigTypeCaster.cast(baseType, arrValue.trim());
                                Array.set(array, index, objectValue);
                                ++index;
                            }
                            field.set(object, array);
                            break block12;
                        }
                        if (!type.isAssignableFrom(List.class)) break block32;
                        if (value == null) break block12;
                        Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        List list = (List)field.get(object);
                        list.clear();
                        for (String listValue : values3 = value.split(splitter)) {
                            if (listValue.trim().isEmpty()) continue;
                            list.add(ConfigTypeCaster.cast(genericType, listValue.trim()));
                        }
                        break block12;
                    }
                    if (!type.isAssignableFrom(EnumSet.class)) break block33;
                    if (value == null) break block12;
                    Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    EnumSet set = (EnumSet)field.get(object);
                    set.clear();
                    for (String listValue : values2 = value.split(splitter)) {
                        set.add(ConfigTypeCaster.cast(genericType, listValue.trim()));
                    }
                    break block12;
                }
                if (!type.isAssignableFrom(HashSet.class)) break block34;
                if (value == null) break block12;
                Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                HashSet set = (HashSet)field.get(object);
                set.clear();
                for (String listValue : values = value.split(splitter)) {
                    set.add(ConfigTypeCaster.cast(genericType, listValue.trim()));
                }
                break block12;
            }
            try {
                field.set(object, type.getDeclaredConstructor(String.class).newInstance(value));
            }
            catch (Exception e) {
                throw new RuntimeException("Unsupported type [" + field.getType().getName() + "] for field [" + field.getName() + "]", e);
            }
        }
    }

    @Nullable
    public static <T> T cast(Class<T> type, String value) throws IllegalAccessException {
        String parseValue = value;
        if (StringUtils.isEmpty((CharSequence)value) && (Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Short.TYPE || type == Float.TYPE || type == Double.TYPE || type == Long.TYPE)) {
            parseValue = "0";
        }
        if (type.isEnum()) {
            if (StringUtils.isNumeric((CharSequence)value)) {
                return type.getEnumConstants()[Integer.parseInt(value)];
            }
            return Enum.valueOf(type, value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.decode(parseValue);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.decode(parseValue);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(parseValue);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(parseValue);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.decode(parseValue);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (NumberUtils.isDigits((String)value)) {
                return (T)Boolean.valueOf(value.equals("1"));
            }
            return (T)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.decode(value);
        }
        if (type == AtomicInteger.class) {
            return (T)new AtomicInteger(Integer.decode(value));
        }
        if (type == AtomicBoolean.class) {
            return (T)new AtomicBoolean(Boolean.parseBoolean(value));
        }
        if (type == AtomicLong.class) {
            return (T)new AtomicLong(Long.decode(parseValue));
        }
        if (type == BigInteger.class) {
            return (T)new BigInteger(parseValue);
        }
        if (type == BigDecimal.class) {
            return (T)new BigDecimal(parseValue);
        }
        if (type == Path.class) {
            return (T)Paths.get(value, new String[0]);
        }
        if (type == Pattern.class) {
            return (T)Pattern.compile(value);
        }
        if (type == Duration.class) {
            return (T)Duration.parse(value);
        }
        if (type == UUID.class) {
            return (T)UUID.fromString(value);
        }
        try {
            return type.getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't cast value [" + value + "] to type [" + String.valueOf(type) + "]", e);
        }
    }
}

