/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.datetime.dailytick;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.datetime.dailytick.DailyTickable;
import host.anzo.commons.datetime.dailytick.EDailyTickType;
import host.anzo.commons.datetime.dailytick.IDailyTickable;
import host.anzo.commons.enums.startup.EShutdownPriority;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.service.ThreadPoolService;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service", shutdownPriority=EShutdownPriority.MAJOR)
public class DailyTickService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DailyTickService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final List<Class<?>> consumerClasses = new ArrayList();

    private DailyTickService() {
        ClassIndex.getAnnotated(DailyTickable.class).forEach(item -> {
            DailyTickable annotation = item.getAnnotation(DailyTickable.class);
            if (annotation != null) {
                if (IDailyTickable.class.isAssignableFrom((Class<?>)item)) {
                    this.consumerClasses.add((Class<?>)item);
                } else {
                    log.error("Found marked with DailyTickable annotation class without IDailyTickable implementation: {}", (Object)item.getSimpleName());
                }
            }
        });
        log.info("Found [{}] daily tickable classes.", (Object)this.consumerClasses.size());
        for (EDailyTickType dailyTickType : EDailyTickType.values()) {
            long timeToNextTick = dailyTickType.getTimeToNextTick();
            ThreadPoolService.getInstance().scheduleAtFixedRate(() -> this.runDailyTask(dailyTickType), timeToNextTick, dailyTickType.getTickPeriod(), TimeUnit.MILLISECONDS, "DailyTickService.runDailyTask(" + String.valueOf((Object)dailyTickType) + ")");
            log.info("Scheduled DailyTickType.{} call in [{}] minutes.", (Object)dailyTickType, (Object)TimeUnit.MINUTES.convert(timeToNextTick, TimeUnit.MILLISECONDS));
        }
    }

    private void runDailyTask(EDailyTickType dailyTickType) {
        try {
            DayOfWeek dayOfWeek = LocalDate.now().getDayOfWeek();
            ThreadPoolService.getInstance().submitForkJoinGet(() -> this.consumerClasses.parallelStream().forEach(clazz -> {
                Object object = ClassUtils.singletonInstance(clazz);
                if (object != null && object instanceof IDailyTickable) {
                    ((IDailyTickable)object).onDailyTick(dayOfWeek, dailyTickType);
                }
            }), "DailyTickService.tickTask(" + dailyTickType.toString() + ")");
            log.info("Daily task with type EDailyTickType.{} successfully completed.", (Object)dailyTickType);
        }
        catch (Exception e) {
            log.error("Error while running daily task type=[{}]", (Object)dailyTickType, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static DailyTickService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    DailyTickService actualValue = new DailyTickService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (DailyTickService)($value == instance ? null : $value);
    }
}

