/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.annotations.startup.Scheduled;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.commons.enums.startup.EShutdownPriority;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.commons.threading.CallableWrapper;
import host.anzo.commons.threading.RunnableWrapper;
import host.anzo.commons.threading.ThreadPoolPriorityFactory;
import host.anzo.commons.utils.ConsoleUtils;
import host.anzo.core.config.EmergencyConfig;
import host.anzo.core.config.ThreadPoolConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metric
@StartupComponent(value="Threading", shutdownPriority=EShutdownPriority.MINOR)
public class ThreadPoolService
implements IShutdownable,
IMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ScheduledThreadPoolExecutor SYSTEM_SCHEDULER;
    private final ThreadPoolExecutor SYSTEM_EXECUTOR;
    private final ExecutorService VIRTUAL_EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();
    private final ForkJoinPool FORK_JOIN_POOL;
    private final PropertyNode SYSTEM_SCHEDULER_METRICS;
    private final PropertyNode SYSTEM_EXECUTOR_METRICS;
    private final PropertyNode VIRTUAL_EXECUTOR_METRICS;
    private final PropertyNode FORK_JOIN_POOL_METRICS;
    private final AtomicBoolean _shutdown = new AtomicBoolean();

    ThreadPoolService() {
        ConsoleUtils.printSection("ThreadPoolManager Loading");
        this.SYSTEM_SCHEDULER = new ScheduledThreadPoolExecutor(ThreadPoolConfig.SCHEDULED_THREAD_POOL_CONFIG[0] > -1 ? ThreadPoolConfig.SCHEDULED_THREAD_POOL_CONFIG[0] : Runtime.getRuntime().availableProcessors(), new ThreadPoolPriorityFactory("[POOL]Scheduled", ThreadPoolConfig.SCHEDULED_THREAD_POOL_CONFIG[1]));
        this.SYSTEM_SCHEDULER.setRemoveOnCancelPolicy(true);
        this.SYSTEM_SCHEDULER.prestartAllCoreThreads();
        this.SYSTEM_SCHEDULER.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.SYSTEM_EXECUTOR = new ThreadPoolExecutor(ThreadPoolConfig.THREAD_POOL_EXECUTOR_CONFIG[0] > -1 ? ThreadPoolConfig.THREAD_POOL_EXECUTOR_CONFIG[0] : Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolPriorityFactory("[POOL]Execute", ThreadPoolConfig.THREAD_POOL_EXECUTOR_CONFIG[1]));
        this.SYSTEM_EXECUTOR.prestartAllCoreThreads();
        this.FORK_JOIN_POOL = new ForkJoinPool(ThreadPoolConfig.FORK_JOIN_POOL_CONFIG[0] > -1 ? ThreadPoolConfig.FORK_JOIN_POOL_CONFIG[0] : Runtime.getRuntime().availableProcessors(), pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("[POOL]ForkJoin-" + this.threadNumber.getAndIncrement());
            worker.setPriority(ThreadPoolConfig.FORK_JOIN_POOL_CONFIG[1]);
            return worker;
        }, null, true);
        this.SYSTEM_SCHEDULER_METRICS = Metrics.create();
        this.SYSTEM_EXECUTOR_METRICS = Metrics.create();
        this.VIRTUAL_EXECUTOR_METRICS = Metrics.create();
        this.FORK_JOIN_POOL_METRICS = Metrics.create();
        this.printStats();
    }

    public void execute(@NotNull Runnable task) {
        this.execute(task, false);
    }

    public void execute(@NotNull Runnable task, String name) {
        this.execute(task, false, name);
    }

    public void execute(Runnable task, boolean isVirtual) {
        this.execute(task, isVirtual, null);
    }

    public void execute(@NotNull Runnable task, boolean isVirtual, String name) {
        block3: {
            try {
                if (EmergencyConfig.ENABLE_METRICS) {
                    (isVirtual ? this.VIRTUAL_EXECUTOR_METRICS : this.SYSTEM_EXECUTOR_METRICS).record(Metrics.happened((String)(name != null ? name : task.getClass().getName())));
                }
                (isVirtual ? this.VIRTUAL_EXECUTOR : this.SYSTEM_EXECUTOR).execute(new RunnableWrapper(task, isVirtual, name));
            }
            catch (RejectedExecutionException e) {
                if (this.isShutdown()) break block3;
                log.error("Executor: Failed execute task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
    }

    @NotNull
    public <V> Future<V> submit(@NotNull Callable<V> c, V defaultValue) {
        return this.submit(c, defaultValue, false);
    }

    @NotNull
    public <V> Future<V> submit(@NotNull Callable<V> c, V defaultValue, String name) {
        return this.submit(c, defaultValue, false, name);
    }

    @NotNull
    public <V> Future<V> submit(@NotNull Callable<V> c, V defaultValue, boolean virtual) {
        return this.submit(c, defaultValue, virtual, null);
    }

    @NotNull
    public <V> Future<V> submit(@NotNull Callable<V> c, V defaultValue, boolean virtual, String name) {
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                (virtual ? this.VIRTUAL_EXECUTOR_METRICS : this.SYSTEM_EXECUTOR_METRICS).record(Metrics.happened((String)(name != null ? name : c.getClass().getSimpleName())));
            }
            return (virtual ? this.VIRTUAL_EXECUTOR : this.SYSTEM_EXECUTOR).submit(new CallableWrapper<V>(c, defaultValue, virtual, name));
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed submit task!", (Throwable)e);
                Thread.dumpStack();
            }
            return new RejectedFuture<V>(defaultValue, e);
        }
    }

    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable task, long delay) {
        return this.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable task, long delay, TimeUnit unit) {
        return this.schedule(task, delay, unit, null);
    }

    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable task, long delay, TimeUnit unit, String name) {
        try {
            if (unit == null) {
                unit = TimeUnit.MILLISECONDS;
            }
            if (delay <= 0L) {
                delay = 0L;
                unit = TimeUnit.MILLISECONDS;
            }
            if (EmergencyConfig.ENABLE_METRICS) {
                String metricName = name != null ? name : task.getClass().getName();
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.happened((String)metricName));
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.value((String)(metricName + "[schedule delay]"), (long)TimeUnit.MILLISECONDS.convert(delay, unit)));
            }
            return this.SYSTEM_SCHEDULER.schedule(new RunnableWrapper(task, name), delay, unit);
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Scheduler: Failed schedule task!", (Throwable)e);
                Thread.dumpStack();
            }
            return new RejectedFuture<Object>(null, e);
        }
    }

    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, long initialDelay, long period) {
        return this.scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleAtFixedRate(task, initialDelay, period, unit, null);
    }

    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, long initialDelay, long period, TimeUnit unit, String name) {
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                String metricName = name != null ? name : task.getClass().getName();
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.happened((String)metricName));
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.value((String)(metricName + "[schedule fixed rate]"), (long)TimeUnit.MILLISECONDS.convert(period, unit)));
            }
            return this.SYSTEM_SCHEDULER.scheduleAtFixedRate(new RunnableWrapper(task, name), Math.max(1L, initialDelay), Math.max(1L, period), unit);
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Scheduler: Failed schedule task!", (Throwable)e);
                Thread.dumpStack();
            }
            return new RejectedFuture<Object>(null, e);
        }
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, long initialDelay, long delay) {
        return this.scheduleWithFixedDelay(task, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleWithFixedDelay(task, initialDelay, delay, unit, null);
    }

    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, long initialDelay, long delay, TimeUnit unit, String name) {
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                String metricName = name != null ? name : task.getClass().getName();
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.happened((String)metricName));
                this.SYSTEM_SCHEDULER_METRICS.record(Metrics.value((String)(metricName + "[schedule fixed delay]"), (long)TimeUnit.MILLISECONDS.convert(delay, unit)));
            }
            return this.SYSTEM_SCHEDULER.scheduleWithFixedDelay(new RunnableWrapper(task, name), Math.max(1L, initialDelay), Math.max(1L, delay), unit);
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Scheduler: Failed schedule task!", (Throwable)e);
                Thread.dumpStack();
            }
            return new RejectedFuture<Object>(null, e);
        }
    }

    public <U> CompletableFuture<U> supplyAsync(@NotNull Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.FORK_JOIN_POOL);
    }

    public CompletableFuture<Void> runAsync(@NotNull Runnable task) {
        return CompletableFuture.runAsync(task, this.FORK_JOIN_POOL);
    }

    public void executeForkJoin(@NotNull Runnable task) {
        this.executeForkJoin(task, null);
    }

    public void executeForkJoin(@NotNull Runnable task, String name) {
        block3: {
            try {
                if (EmergencyConfig.ENABLE_METRICS) {
                    this.FORK_JOIN_POOL_METRICS.record(Metrics.happened((String)(name != null ? name : task.getClass().getName())));
                }
                this.FORK_JOIN_POOL.execute(new RunnableWrapper(task, name));
            }
            catch (RejectedExecutionException e) {
                if (this.isShutdown()) break block3;
                log.error("Executor: Failed execute task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
    }

    public void submitForkJoinGet(@NotNull Runnable task, String name) {
        try {
            this.submitForkJoin(task, name).get();
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed submit task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
        catch (Exception e) {
            log.error("Executor: Failed submit task!", (Throwable)e);
        }
    }

    public ForkJoinTask<?> submitForkJoin(@NotNull Runnable task, String name) {
        if (EmergencyConfig.ENABLE_METRICS) {
            this.FORK_JOIN_POOL_METRICS.record(Metrics.happened((String)name));
        }
        return this.FORK_JOIN_POOL.submit(new RunnableWrapper(task, name));
    }

    public <V> V submitForkJoinGet(@NotNull Callable<V> task, V defaultValue, String name) {
        try {
            return this.submitForkJoin(task, name).get();
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed submit task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
        catch (Exception e) {
            log.error("Executor: Failed submit task!", (Throwable)e);
        }
        return defaultValue;
    }

    public <V> ForkJoinTask<V> submitForkJoin(@NotNull Callable<V> task, String name) {
        return this.submitForkJoin(task, null, name);
    }

    public <V> ForkJoinTask<V> submitForkJoin(@NotNull Callable<V> task, V defaultValue, String name) {
        if (EmergencyConfig.ENABLE_METRICS) {
            this.FORK_JOIN_POOL_METRICS.record(Metrics.happened((String)name));
        }
        return this.FORK_JOIN_POOL.submit(new CallableWrapper<V>(task, defaultValue, false, name));
    }

    public <V> V submitExternalForkJoinGet(@NotNull Callable<V> task, V defaultValue, String name) {
        try {
            return this.submitExternalForkJoin(ForkJoinTask.adapt(new CallableWrapper<V>(task, defaultValue, false, name)), name).get();
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed submit task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
        catch (Exception e) {
            log.error("Executor: Failed submit task!", (Throwable)e);
        }
        return defaultValue;
    }

    public void submitExternalForkJoinGet(@NotNull Runnable task, String name) {
        try {
            this.submitExternalForkJoin(ForkJoinTask.adapt(new RunnableWrapper(task, false, name)), name).get();
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed submit task!", (Throwable)e);
                Thread.dumpStack();
            }
        }
        catch (Exception e) {
            log.error("Executor: Failed submit task!", (Throwable)e);
        }
    }

    @NotNull
    public <T> ForkJoinTask<T> submitExternalForkJoin(@NotNull ForkJoinTask<T> task, String name) {
        if (EmergencyConfig.ENABLE_METRICS) {
            this.FORK_JOIN_POOL_METRICS.record(Metrics.happened((String)name));
        }
        return this.FORK_JOIN_POOL.externalSubmit(task);
    }

    @Nullable
    public Thread toVT(@NotNull Runnable task) {
        try {
            if (EmergencyConfig.ENABLE_METRICS) {
                this.VIRTUAL_EXECUTOR_METRICS.record(Metrics.happened((String)task.getClass().getName()));
            }
            return Thread.ofVirtual().start(task);
        }
        catch (RejectedExecutionException e) {
            if (!this.isShutdown()) {
                log.error("Executor: Failed virtualize task!", (Throwable)e);
                Thread.dumpStack();
            }
            return null;
        }
    }

    public void toVTJoin(Runnable task) {
        try {
            Thread virtualThread = this.toVT(task);
            if (virtualThread != null) {
                virtualThread.join();
            }
        }
        catch (InterruptedException e) {
            log.error("Executor: Failed virtualize task!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public ScheduledExecutorService getScheduler() {
        return this.SYSTEM_SCHEDULER;
    }

    public ExecutorService getExecutor() {
        return this.SYSTEM_EXECUTOR;
    }

    public ForkJoinPool getForkJoinPool() {
        return this.FORK_JOIN_POOL;
    }

    @NotNull
    public String getStats() {
        TextStringBuilder builder = new TextStringBuilder();
        builder.appendln(" | ----------------");
        builder.appendln(" + SystemScheduler:");
        builder.appendln(" |- ActiveThreads:       " + this.SYSTEM_SCHEDULER.getActiveCount());
        builder.appendln(" |- CorePoolSize:        " + this.SYSTEM_SCHEDULER.getCorePoolSize());
        builder.appendln(" |- PoolSize:            " + this.SYSTEM_SCHEDULER.getPoolSize());
        builder.appendln(" |- MaximumPoolSize:     " + this.SYSTEM_SCHEDULER.getMaximumPoolSize());
        builder.appendln(" |- CompletedTasks:      " + this.SYSTEM_SCHEDULER.getCompletedTaskCount());
        builder.appendln(" |- ScheduledTasks:      " + this.SYSTEM_SCHEDULER.getQueue().size());
        builder.appendln(" | ----------------");
        builder.appendln(" + SystemExecutor:");
        builder.appendln(" |- ActiveThreads:       " + this.SYSTEM_EXECUTOR.getActiveCount());
        builder.appendln(" |- CorePoolSize:        " + this.SYSTEM_EXECUTOR.getCorePoolSize());
        builder.appendln(" |- PoolSize:            " + this.SYSTEM_EXECUTOR.getPoolSize());
        builder.appendln(" |- MaximumPoolSize:     " + this.SYSTEM_EXECUTOR.getMaximumPoolSize());
        builder.appendln(" |- CompletedTasks:      " + this.SYSTEM_EXECUTOR.getCompletedTaskCount());
        builder.appendln(" |- ScheduledTasks:      " + this.SYSTEM_EXECUTOR.getQueue().size());
        builder.appendln(" | ----------------");
        builder.appendln(" + ForkJoinPool:");
        builder.appendln(" |- ActiveThreads:       " + this.FORK_JOIN_POOL.getActiveThreadCount());
        builder.appendln(" |- PoolSize:            " + this.FORK_JOIN_POOL.getPoolSize());
        builder.appendln(" |- QueuedTasks:         " + this.FORK_JOIN_POOL.getQueuedTaskCount());
        builder.appendln(" |- RunningThreadCount:  " + this.FORK_JOIN_POOL.getRunningThreadCount());
        builder.appendln(" | ----------------");
        return builder.toString();
    }

    public void printStats() {
        log.info("ThreadPoolService statistic:");
        for (String statsLine : this.getStats().split("\n")) {
            log.info(statsLine);
        }
    }

    @Override
    @NotNull
    public List<MetricResult> getMetric() {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        MetricResult scheduleResult = new MetricResult();
        scheduleResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        scheduleResult.setName("SystemScheduler");
        scheduleResult.setData((String)this.SYSTEM_SCHEDULER_METRICS.render().get());
        metricResults.add(scheduleResult);
        MetricResult systemExecutorResult = new MetricResult();
        systemExecutorResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        systemExecutorResult.setName("SystemExecutor");
        systemExecutorResult.setData((String)this.SYSTEM_EXECUTOR_METRICS.render().get());
        metricResults.add(systemExecutorResult);
        MetricResult virtualExecutorResult = new MetricResult();
        virtualExecutorResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        virtualExecutorResult.setName("VirtualExecutor");
        virtualExecutorResult.setData((String)this.VIRTUAL_EXECUTOR_METRICS.render().get());
        metricResults.add(virtualExecutorResult);
        MetricResult forkJoinResult = new MetricResult();
        forkJoinResult.setMetricGroupType(MetricGroupType.THREADPOOL);
        forkJoinResult.setName("ForkJoinPool");
        forkJoinResult.setData((String)this.FORK_JOIN_POOL_METRICS.render().get());
        metricResults.add(forkJoinResult);
        return metricResults;
    }

    @Scheduled(period=10L, timeUnit=TimeUnit.MINUTES, runAfterServerStart=true)
    public void purge() {
        this.SYSTEM_SCHEDULER.purge();
        this.SYSTEM_EXECUTOR.purge();
        this.printStats();
    }

    public boolean isShutdown() {
        return this._shutdown.get();
    }

    public void onShutdown() {
        if (this._shutdown.compareAndSet(false, true)) {
            try {
                this.SYSTEM_SCHEDULER.shutdown();
                this.SYSTEM_EXECUTOR.shutdown();
                this.VIRTUAL_EXECUTOR.shutdown();
                this.FORK_JOIN_POOL.shutdown();
                boolean terminated = this.SYSTEM_SCHEDULER.awaitTermination(10L, TimeUnit.SECONDS);
                this.logTerminationResult(this.SYSTEM_SCHEDULER, terminated);
                terminated = this.SYSTEM_EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS);
                this.logTerminationResult(this.SYSTEM_EXECUTOR, terminated);
                terminated = this.VIRTUAL_EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS);
                this.logTerminationResult(this.VIRTUAL_EXECUTOR, terminated);
                terminated = this.FORK_JOIN_POOL.awaitTermination(10L, TimeUnit.SECONDS);
                this.logTerminationResult(this.FORK_JOIN_POOL, terminated);
                log.info("All ThreadPools are now stopped.");
            }
            catch (InterruptedException e) {
                log.error("Error while shutdown()", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void logTerminationResult(ExecutorService executor, boolean terminated) {
        if (terminated) {
            log.info("{} terminated successfully.", (Object)executor);
        } else {
            log.warn("{} did not terminate within the timeout.", (Object)executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ThreadPoolService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ThreadPoolService actualValue = new ThreadPoolService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ThreadPoolService)($value == instance ? null : $value);
    }

    private record RejectedFuture<V>(V defaultValue, Throwable cause) implements ScheduledFuture<V>
    {
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public V get() {
            if (this.cause != null) {
                log.warn("Try get from RejectedFuture. Return default value. Cause:", this.cause);
            } else {
                log.warn("Try get from RejectedFuture. Return default value.");
            }
            return this.defaultValue;
        }

        @Override
        public V get(long timeout, @NotNull TimeUnit unit) {
            if (this.cause != null) {
                log.warn("Try get with timeout from RejectedFuture. Return default value immediately. Cause:", this.cause);
            } else {
                log.warn("Try get with timeout from RejectedFuture. Return default value immediately.");
            }
            return this.defaultValue;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            return 0;
        }
    }
}

