/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.io.binary;

import host.anzo.commons.unsafe.ByteBufferCleaner;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferEx
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByteBufferEx.class);
    private ByteBuffer buffer;
    private final boolean isDirect;
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicReference<ByteBufferExState> byteBufferState = new AtomicReference<ByteBufferExState>(ByteBufferExState.Idle);

    public ByteBufferEx(int capacity, ByteOrder byteOrder, boolean isDirect) {
        this.isDirect = isDirect;
        this.buffer = isDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.buffer.order(byteOrder);
    }

    public ByteBufferEx(byte @NotNull [] data, ByteOrder byteOrder) {
        this(data.length, byteOrder, false);
        this.buffer.put(data);
        this.buffer.position(0);
    }

    public ByteBufferEx(InputStream inputStream, ByteOrder byteOrder) throws IOException {
        this(IOUtils.toByteArray((InputStream)inputStream), byteOrder);
    }

    public int position() {
        int position = 0;
        if (this.checkAccess()) {
            position = this.buffer.position();
            this.checkDestroy();
        }
        return position;
    }

    public Buffer position(int pos) {
        ByteBuffer buffer = null;
        if (this.checkAccess()) {
            buffer = this.buffer.position(pos);
            this.checkDestroy();
        }
        return buffer;
    }

    public void limit(int limit) {
        if (this.checkAccess()) {
            this.buffer.limit(limit);
            this.checkDestroy();
        }
    }

    public int limit() {
        int limit = 0;
        if (this.checkAccess()) {
            limit = this.buffer.limit();
            this.checkDestroy();
        }
        return limit;
    }

    public int remaining() {
        int remaining = 0;
        if (this.checkAccess()) {
            remaining = this.buffer.remaining();
            this.checkDestroy();
        }
        return remaining;
    }

    public boolean hasRemaining() {
        boolean hasRemaining = false;
        if (this.checkAccess()) {
            hasRemaining = this.buffer.hasRemaining();
            this.checkDestroy();
        }
        return hasRemaining;
    }

    public void flip() {
        if (this.checkAccess()) {
            this.buffer.flip();
            this.checkDestroy();
        }
    }

    public int capacity() {
        int capacity = 0;
        if (this.checkAccess()) {
            capacity = this.buffer.capacity();
            this.checkDestroy();
        }
        return capacity;
    }

    public void compact() {
        if (this.checkAccess()) {
            this.buffer.compact();
            this.checkDestroy();
        }
    }

    public void clear() {
        if (this.checkAccess()) {
            this.buffer.clear();
            this.checkDestroy();
        }
    }

    public final void skip(int bytes) {
        if (this.checkAccess()) {
            if (this.buffer.remaining() < bytes) {
                throw new BufferUnderflowException();
            }
            this.buffer.position(this.buffer.position() + bytes);
            this.checkDestroy();
        }
    }

    public final void skipAll() {
        if (this.checkAccess()) {
            this.buffer.position(this.buffer.limit());
            this.checkDestroy();
        }
    }

    public final void readB(byte[] dst) {
        if (this.checkAccess()) {
            this.buffer.get(dst);
            this.checkDestroy();
        }
    }

    public final byte @NotNull [] readB(int len) {
        byte[] tmp = new byte[len];
        if (this.checkAccess()) {
            this.buffer.get(tmp);
            this.checkDestroy();
        }
        return tmp;
    }

    @NotNull
    public final ByteBufferEx readBuffer(int len) {
        byte[] tmp = new byte[len];
        if (this.checkAccess()) {
            this.buffer.get(tmp);
            this.checkDestroy();
        }
        return new ByteBufferEx(tmp, ByteOrder.LITTLE_ENDIAN);
    }

    public final void readB(byte[] dst, int offset, int len) {
        if (this.checkAccess()) {
            this.buffer.get(dst, offset, len);
            this.checkDestroy();
        }
    }

    public final byte readC() {
        byte result = 0;
        if (this.checkAccess()) {
            result = (byte)(this.buffer.get() & 0xFF);
            this.checkDestroy();
        }
        return result;
    }

    public final int readCD() {
        int result = 0;
        if (this.checkAccess()) {
            result = this.buffer.get() & 0xFF;
            this.checkDestroy();
        }
        return result;
    }

    public final boolean readCB() {
        boolean result = false;
        if (this.checkAccess()) {
            result = (this.buffer.get() & 0xFF) == 1;
            this.checkDestroy();
        }
        return result;
    }

    public final boolean readCB(int align) {
        boolean result = false;
        if (this.checkAccess()) {
            result = (this.buffer.get() & 0xFF) == 1;
            this.buffer.get(new byte[align - 1]);
            this.checkDestroy();
        }
        return result;
    }

    public final int readHD() {
        int result = 0;
        if (this.checkAccess()) {
            result = this.buffer.getShort() & 0xFFFF;
            this.checkDestroy();
        }
        return result;
    }

    public final short readH() {
        short result = 0;
        if (this.checkAccess()) {
            result = (short)(this.buffer.getShort() & 0xFFFF);
            this.checkDestroy();
        }
        return result;
    }

    public final short readH(int position) {
        short result = 0;
        if (this.checkAccess()) {
            result = (short)(this.buffer.getShort(position) & 0xFFFF);
            this.checkDestroy();
        }
        return result;
    }

    public final int readD() {
        int result = 0;
        if (this.checkAccess()) {
            result = this.buffer.getInt();
            this.checkDestroy();
        }
        return result;
    }

    public final int readD(int position) {
        int result = 0;
        if (this.checkAccess()) {
            result = this.buffer.getInt(position);
            this.checkDestroy();
        }
        return result;
    }

    public final long readDQ() {
        long result = 0L;
        if (this.checkAccess()) {
            result = (long)this.buffer.getInt() & 0xFFFFFFFFL;
            this.checkDestroy();
        }
        return result;
    }

    public final long readDQ(int position) {
        long result = 0L;
        if (this.checkAccess()) {
            result = this.buffer.getInt(position);
            this.checkDestroy();
        }
        return result;
    }

    public final int readD3() {
        int result = 0;
        if (this.checkAccess()) {
            result = this.buffer.get() & 0xFF;
            result |= this.buffer.get() << 8 & 0xFF00;
            result |= this.buffer.get() << 16 & 0xFF0000;
            this.checkDestroy();
        }
        return result;
    }

    public final long readQ() {
        long result = 0L;
        if (this.checkAccess()) {
            result = this.buffer.getLong();
            this.checkDestroy();
        }
        return result;
    }

    public final float readF() {
        float result = 0.0f;
        if (this.checkAccess()) {
            result = this.buffer.getFloat();
            this.checkDestroy();
        }
        return result;
    }

    public final String readStringUnicode(int padding) {
        TextStringBuilder stringBuilder = new TextStringBuilder();
        if (this.checkAccess()) {
            while (padding > 0) {
                padding -= 2;
                char c = this.buffer.getChar();
                if (c == '\u0000') break;
                stringBuilder.append(c);
            }
            this.skip(padding);
            this.checkDestroy();
        }
        return stringBuilder.build();
    }

    public final String readStringUnicodeNT() {
        TextStringBuilder stringBuilder = new TextStringBuilder();
        if (this.checkAccess()) {
            char c;
            while ((c = this.buffer.getChar()) != '\u0000') {
                stringBuilder.append(c);
            }
            this.checkDestroy();
        }
        return stringBuilder.build();
    }

    public final String readStringUnicodeNT(int size) {
        TextStringBuilder stringBuilder = new TextStringBuilder();
        if (this.checkAccess()) {
            while (size > 0) {
                char c = this.buffer.getChar();
                if (c != '\u0000') {
                    stringBuilder.append(c);
                }
                size -= 2;
            }
            this.checkDestroy();
        }
        return stringBuilder.build();
    }

    @NotNull
    public final String readString(int size) {
        byte[] bytes = new byte[size];
        if (this.checkAccess()) {
            this.buffer.get(bytes);
            this.checkDestroy();
        }
        return new String(bytes);
    }

    @NotNull
    public final String readString() {
        int length;
        if (this.checkAccess() && (length = this.readHD()) > 0) {
            byte[] bytes = new byte[length];
            this.buffer.get(bytes);
            this.checkDestroy();
            return new String(bytes);
        }
        return "";
    }

    @NotNull
    public final String readStringNT(int size) {
        TextStringBuilder stringBuilder = new TextStringBuilder();
        if (this.checkAccess()) {
            byte charByte;
            byte[] byteBuffer = this.readB(size);
            for (int byteIndex = 0; byteIndex < size && (charByte = byteBuffer[byteIndex]) != 0; ++byteIndex) {
                stringBuilder.append((char)charByte);
            }
            this.checkDestroy();
        }
        return stringBuilder.get();
    }

    public final <T extends Enum<T>> T readEnum(Class<T> enumClass, T defaultValue) {
        int ordinalValue = this.readCD();
        try {
            return (T)((Enum[])enumClass.getEnumConstants())[ordinalValue];
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public final void write(@NotNull Object value, Integer ... params) {
        Class<?> clazz = value.getClass();
        if (clazz == Short.class) {
            this.writeH(((Short)value).shortValue());
        } else if (clazz == Integer.class) {
            this.writeD((Integer)value);
        } else if (clazz == Long.class) {
            this.writeQ((Long)value);
        } else if (clazz == Double.class) {
            this.writeF((Double)value);
        } else if (clazz == Float.class) {
            this.writeF(((Float)value).floatValue());
        } else if (clazz == Byte.class) {
            this.writeC(((Byte)value).byteValue());
        } else if (clazz == Boolean.class) {
            this.writeC((Boolean)value != false ? 1 : 0);
        } else if (clazz == byte[].class) {
            this.writeB((byte[])value);
        } else if (clazz == String.class) {
            this.writeStringUnicode((String)value, params[0]);
        } else {
            log.error("Method didn't support write for clazz=[{}]", clazz);
        }
    }

    public final void writeC(boolean value) {
        if (this.checkAccess()) {
            this.buffer.put((byte)(value ? 1 : 0));
            this.checkDestroy();
        }
    }

    public final void writeC(int value) {
        if (this.checkAccess()) {
            this.buffer.put((byte)value);
            this.checkDestroy();
        }
    }

    public final void writeC(Enum<?> value) {
        if (this.checkAccess()) {
            this.buffer.put((byte)value.ordinal());
            this.checkDestroy();
        }
    }

    public final void writeC(byte[] byteArray) {
        if (this.checkAccess()) {
            for (byte value : byteArray) {
                this.writeC(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeH(boolean value) {
        if (this.checkAccess()) {
            this.buffer.putShort((short)(value ? 1 : 0));
            this.checkDestroy();
        }
    }

    public final void writeH(int value) {
        if (this.checkAccess()) {
            this.buffer.putShort((short)value);
            this.checkDestroy();
        }
    }

    public final void writeH(short[] shortArray) {
        if (this.checkAccess()) {
            for (short value : shortArray) {
                this.writeH(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeH(int[] intArray) {
        if (this.checkAccess()) {
            for (int value : intArray) {
                this.writeH(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeD(boolean value) {
        if (this.checkAccess()) {
            this.buffer.putInt(value ? 1 : 0);
            this.checkDestroy();
        }
    }

    public final void writeD(int value) {
        if (this.checkAccess()) {
            this.buffer.putInt(value);
            this.checkDestroy();
        }
    }

    public final void writeD(int value, int align) {
        if (this.checkAccess()) {
            this.buffer.putInt(value);
            this.buffer.put(new byte[align - 4]);
            this.checkDestroy();
        }
    }

    public final void writeD(long value) {
        if (this.checkAccess()) {
            this.buffer.putInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
            this.checkDestroy();
        }
    }

    public final void writeD(int[] intArray) {
        if (this.checkAccess()) {
            for (int value : intArray) {
                this.writeD(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeQ(boolean value) {
        if (this.checkAccess()) {
            this.buffer.putLong(value ? 1L : 0L);
            this.checkDestroy();
        }
    }

    public final void writeQ(long value) {
        if (this.checkAccess()) {
            this.buffer.putLong(value);
            this.checkDestroy();
        }
    }

    public final void writeQ(long[] longArray) {
        if (this.checkAccess()) {
            for (long value : longArray) {
                this.writeQ(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeF(float value) {
        if (this.checkAccess()) {
            this.buffer.putFloat(value);
            this.checkDestroy();
        }
    }

    public final void writeF(float[] floatArray) {
        if (this.checkAccess()) {
            for (float value : floatArray) {
                this.writeF(value);
            }
            this.checkDestroy();
        }
    }

    public final void writeF(double value) {
        if (this.checkAccess()) {
            this.buffer.putFloat((float)value);
            this.checkDestroy();
        }
    }

    public final void writeF(int value) {
        if (this.checkAccess()) {
            this.buffer.putFloat(value);
            this.checkDestroy();
        }
    }

    public final void writeArray(Object[] objectArray) {
        if (this.checkAccess()) {
            for (Object object : objectArray) {
                this.write(object, new Integer[0]);
            }
            this.checkDestroy();
        }
    }

    public final void writeB(byte[] data) {
        if (this.checkAccess()) {
            this.buffer.put(data);
            this.checkDestroy();
        }
    }

    public final void writeB(int size) {
        if (this.checkAccess()) {
            this.buffer.put(new byte[size]);
            this.checkDestroy();
        }
    }

    public final void writeD3(int value) {
        if (this.checkAccess()) {
            this.buffer.put((byte)(value & 0xFF));
            this.buffer.put((byte)((value & 0xFF00) >> 8));
            this.buffer.put((byte)((value & 0xFF0000) >> 16));
            this.checkDestroy();
        }
    }

    public final void writeString(CharSequence charSequence, int size) {
        if (this.checkAccess()) {
            int length = 0;
            if (charSequence != null) {
                length = charSequence.length();
                for (int i = 0; i < length; ++i) {
                    this.buffer.put((byte)(charSequence.charAt(i) & 0xFF));
                }
            }
            if (length < size) {
                this.writeB(new byte[size - length]);
            }
            this.checkDestroy();
        }
    }

    public final void writeString(CharSequence charSequence) {
        if (this.checkAccess()) {
            if (charSequence != null) {
                int length = charSequence.length();
                this.buffer.putShort((short)length);
                for (int i = 0; i < length; ++i) {
                    this.buffer.put((byte)(charSequence.charAt(i) & 0xFF));
                }
            }
            this.checkDestroy();
        }
    }

    public final void writeStringUnicodeNT(CharSequence charSequence) {
        if (this.checkAccess()) {
            int length = charSequence.length();
            this.buffer.putShort((short)(length * 2 + 2));
            for (int i = 0; i < length; ++i) {
                this.buffer.putChar(charSequence.charAt(i));
            }
            this.buffer.putChar('\u0000');
            this.checkDestroy();
        }
    }

    public final void writeStringUnicode(CharSequence charSequence, int size) {
        if (this.checkAccess()) {
            if (charSequence == null) {
                this.buffer.put(new byte[size]);
            } else {
                int startPosition = this.buffer.position();
                for (int i = 0; i < charSequence.length(); ++i) {
                    if (this.buffer.position() - startPosition >= size) continue;
                    this.buffer.putChar(charSequence.charAt(i));
                }
                int length = this.buffer.position() - startPosition;
                if (length < size) {
                    this.writeB(new byte[size - length]);
                }
            }
            this.checkDestroy();
        }
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public byte[] toByteArray() {
        if (this.buffer.hasArray()) {
            byte[] array = this.buffer.array();
            return Arrays.copyOfRange(array, 0, this.buffer.limit());
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean writeToFile(Path path) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile(), false);){
            boolean bl;
            block13: {
                FileChannel channel = fileOutputStream.getChannel();
                try {
                    this.buffer.flip();
                    boolean bl2 = bl = channel.write(this.buffer) > 0;
                    if (channel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.error("Error while writing buffer to file [{}]", (Object)path.toString(), (Object)e);
            return false;
        }
    }

    public boolean checkAccess() {
        return !this.isDirect || this.byteBufferState.compareAndSet(ByteBufferExState.Idle, ByteBufferExState.Access) || this.byteBufferState.get() == ByteBufferExState.Access;
    }

    public void checkDestroy() {
        if (this.isDestroyed.get()) {
            this.byteBufferState.set(ByteBufferExState.Destroyed);
            this.destroy();
        } else {
            this.byteBufferState.set(ByteBufferExState.Idle);
        }
    }

    public void tryDestroy() {
        this.isDestroyed.set(true);
        if (!this.isDirect || this.byteBufferState.compareAndSet(ByteBufferExState.Idle, ByteBufferExState.Destroyed)) {
            this.destroy();
        }
    }

    private void destroy() {
        if (this.buffer != null) {
            this.buffer.clear();
            if (this.isDirect) {
                ByteBufferCleaner.clean(this.buffer);
            }
            this.buffer = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.destroy();
    }

    @Generated
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Generated
    public boolean isDirect() {
        return this.isDirect;
    }

    @Generated
    public AtomicBoolean getIsDestroyed() {
        return this.isDestroyed;
    }

    @Generated
    public AtomicReference<ByteBufferExState> getByteBufferState() {
        return this.byteBufferState;
    }

    private static enum ByteBufferExState {
        Idle,
        Access,
        Destroyed;

    }
}

