/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.io.xml;

import host.anzo.commons.utils.ZipUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParser
implements AutoCloseable {
    private final Path filePath;
    private final String name;
    private final String content;
    private final Map<String, String> nameAttributes = new HashMap<String, String>();
    private final Map<String, ArrayList<XmlParser>> nameChildren = new HashMap<String, ArrayList<XmlParser>>();
    private InputStream inputStream;
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    @NotNull
    public static XmlParser fromFile(@NotNull String fileName) {
        XmlParser xmlParser;
        FileInputStream stream = new FileInputStream(fileName);
        try {
            xmlParser = new XmlParser(Paths.get(fileName, new String[0]), Objects.requireNonNull(XmlParser.rootElement(stream)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't parse XML file:" + fileName, e);
            }
        }
        stream.close();
        return xmlParser;
    }

    @NotNull
    public static XmlParser fromPath(@NotNull Path path) {
        XmlParser xmlParser;
        FileInputStream stream = new FileInputStream(path.toFile());
        try {
            xmlParser = new XmlParser(path, Objects.requireNonNull(XmlParser.rootElement(stream)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't parse XML file:" + String.valueOf(path), e);
            }
        }
        stream.close();
        return xmlParser;
    }

    @NotNull
    public static List<XmlParser> fromZip(String ... fileNames) {
        ArrayList<XmlParser> results = new ArrayList<XmlParser>();
        for (String fileName : fileNames) {
            try (FileSystem zipFileSystem = ZipUtils.createZipFileSystem(fileName, false);){
                if (zipFileSystem == null) continue;
                try (Stream<Path> filePathsInZip = Files.walk(zipFileSystem.getPath("/", new String[0]), new FileVisitOption[0]);){
                    filePathsInZip.forEach(filePathInZip -> {
                        if (filePathInZip.toString().endsWith(".xml")) {
                            try (InputStream stream = Files.newInputStream(filePathInZip, new OpenOption[0]);){
                                results.add(XmlParser.fromInputStream(filePathInZip, stream));
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Can't parse XML file name=" + String.valueOf(filePathInZip) + " from zip archive name=" + fileName, e);
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Can't load XML files from zip archive name=" + fileName, e);
            }
        }
        return results;
    }

    @NotNull
    public static XmlParser fromResource(String fileName, @NotNull ClassLoader classLoader) throws IOException {
        return XmlParser.fromInputStream(Paths.get(fileName, new String[0]), classLoader.getResourceAsStream(fileName));
    }

    @NotNull
    public static XmlParser fromInputStream(Path filePath, InputStream inputStream) throws IOException {
        return new XmlParser(filePath, Objects.requireNonNull(XmlParser.rootElement(inputStream)));
    }

    private XmlParser(Path filePath, @NotNull Element element) {
        this.filePath = filePath;
        this.name = element.getNodeName();
        this.content = element.getTextContent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int nodeCount = namedNodeMap.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            Node node = namedNodeMap.item(i);
            String name = node.getNodeName();
            this.nameAttributes.put(name.toLowerCase(), node.getNodeValue());
        }
        NodeList nodes = element.getChildNodes();
        nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != 1) continue;
            XmlParser child = new XmlParser(filePath, (Element)node);
            this.nameChildren.computeIfAbsent(node.getNodeName().toLowerCase(), k -> new ArrayList()).add(child);
        }
    }

    public String getFileName() {
        if (this.filePath == null) {
            return "";
        }
        return this.filePath.getFileName().toString();
    }

    public String getDirectoryName() {
        if (this.filePath == null) {
            return "";
        }
        return this.filePath.getParent().getFileName().toString();
    }

    public String name() {
        return this.name;
    }

    public String content() {
        return this.content;
    }

    public XmlParser child(String name) {
        XmlParser child = this.optChild(name);
        if (child == null) {
            throw new RuntimeException("Could not find child node: " + name);
        }
        return child;
    }

    public XmlParser optChild(String name) {
        List<XmlParser> children = this.children(name);
        int n = children.size();
        if (n > 1) {
            throw new RuntimeException("Could not find individual child node: " + name);
        }
        return n == 0 ? null : (XmlParser)children.stream().findFirst().orElse(null);
    }

    public List<XmlParser> children() {
        return this.nameChildren.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<XmlParser> children(@NotNull String name) {
        List children = this.nameChildren.get(name.toLowerCase());
        return children == null ? new ArrayList() : children;
    }

    public Set<String> attributeNames() {
        return this.nameAttributes.keySet();
    }

    public boolean hasAttribute(@NotNull String attributeName) {
        return this.nameAttributes.containsKey(attributeName.toLowerCase());
    }

    public String readString(@NotNull String name, String defaultValue) {
        String value = this.nameAttributes.get(name.toLowerCase());
        return value != null ? value : defaultValue;
    }

    public String readString(String name) {
        return this.readString(name, null);
    }

    public int readInt(String name, int defaultValue) {
        String result = Optional.ofNullable(this.readString(name)).orElse("").replace("_", "");
        if (NumberUtils.isCreatable((String)result)) {
            return Integer.parseInt(result);
        }
        return defaultValue;
    }

    public int readInt(String name) {
        return Integer.parseInt(Optional.ofNullable(this.readString(name)).orElse("").replace("_", ""));
    }

    public int readIntHex(String name) {
        return Integer.decode(this.readString(name));
    }

    public long readLong(String name, long defaultValue) {
        String result = Optional.ofNullable(this.readString(name)).orElse("").replace("_", "");
        if (NumberUtils.isCreatable((String)result)) {
            return Long.parseUnsignedLong(result);
        }
        return defaultValue;
    }

    public long readLong(String name) {
        return Long.parseLong(Optional.ofNullable(this.readString(name)).orElse("").replace("_", ""));
    }

    public float readFloat(String name, float defaultValue) {
        String result = Optional.ofNullable(this.readString(name)).orElse("").replace("_", "");
        if (!StringUtils.isEmpty((CharSequence)result)) {
            return Float.parseFloat(result);
        }
        return defaultValue;
    }

    public float readFloat(String name) {
        return Float.parseFloat(Optional.ofNullable(this.readString(name)).orElse("").replace("_", ""));
    }

    public boolean readBoolean(String name, boolean defaultValue) {
        String result = this.readString(name);
        if (result != null) {
            return Boolean.parseBoolean(result.toLowerCase());
        }
        return defaultValue;
    }

    public boolean readBoolean(String name) {
        return Boolean.parseBoolean(this.readString(name).toLowerCase());
    }

    public final <T extends Enum<T>> T readEnum(String name, Class<T> enumClass, T defaultValue) {
        String value = this.readString(name);
        if (value == null || StringUtils.isEmpty((CharSequence)value.trim())) {
            return defaultValue;
        }
        try {
            if (StringUtils.isNumeric((CharSequence)value)) {
                return (T)((Enum[])enumClass.getEnumConstants())[Integer.parseInt(value)];
            }
            return Enum.valueOf(enumClass, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but found: " + value, e);
        }
    }

    public List<String> readStringList(String name, String splitter) {
        String value = this.readString(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(splitter)).map(String::trim).collect(Collectors.toList());
    }

    @Nullable
    private static Element rootElement(InputStream inputStream) throws IOException {
        try {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            if (builder != null) {
                Element element = builder.parse(inputStream).getDocumentElement();
                return element;
            }
            Element element = null;
            return element;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException("Can't parse XML document", exception);
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    static {
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
    }
}

