/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.socials.telegram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardRow;

public class TelegramKeyboard {
    private final InlineKeyboardMarkup markup = new InlineKeyboardMarkup(Collections.emptyList());
    private final List<InlineKeyboardRow> keyboard = new ArrayList<InlineKeyboardRow>();

    private TelegramKeyboard() {
    }

    public static TelegramKeyboard create() {
        return new TelegramKeyboard();
    }

    public TelegramKeyboard addButton(int row, String text) {
        try {
            while (this.keyboard.size() <= row) {
                this.keyboard.add(new InlineKeyboardRow());
            }
            this.keyboard.get(row).add((Object)InlineKeyboardButton.builder().text(text).callbackData(text).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public SendMessage attach(@NotNull SendMessage message) {
        this.markup.setKeyboard(this.keyboard);
        message.setReplyMarkup((ReplyKeyboard)this.markup);
        return message;
    }

    public EditMessageText attachEdit(@NotNull EditMessageText message) {
        this.markup.setKeyboard(this.keyboard);
        message.setReplyMarkup(this.markup);
        return message;
    }
}

