/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static <T> T jsonToObject(@NotNull Request request, Class<T> clazz) throws JsonProcessingException {
        return (T)jsonMapper.readValue(request.body(), clazz);
    }

    public static <T> T jsonToObject(String body, Class<T> clazz) throws JsonProcessingException {
        return (T)jsonMapper.readValue(body, clazz);
    }

    public static String dataToJson(@NotNull Response response, Object data) {
        response.type("application/json");
        try {
            return jsonMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            log.error("Error while mapping object to JSON", (Throwable)e);
            return "";
        }
    }

    public static String dataToJson(Object data) {
        try {
            return jsonMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            log.error("Error while mapping object to JSON", (Throwable)e);
            return "";
        }
    }

    static {
        jsonMapper.setVisibility(((SerializationConfig)((SerializationConfig)jsonMapper.getSerializationConfig().with(SerializationFeature.INDENT_OUTPUT).with(SerializationFeature.WRITE_ENUMS_USING_INDEX).with(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES})).with(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public static class CustomBooleanDeserializer
    extends JsonDeserializer<Boolean> {
        public Boolean deserialize(@NotNull JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken currentToken = jp.getCurrentToken();
            if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
                String text = jp.getText().toLowerCase();
                if (text.equals("true") || text.equals("y") || text.equals("yes") || text.equals("1")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
                return Boolean.FALSE;
            }
            ctxt.reportInputMismatch((JsonDeserializer)this, "Can't parse boolean value: " + jp.getText(), new Object[0]);
            return false;
        }
    }
}

