/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.extensions.cachedenum.CachedEnum;
import host.anzo.core.extensions.cachedenum.ICachedEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class CachedEnumService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedEnumService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final Map<String, List<Enum<?>>> cache = new HashMap();

    private CachedEnumService() {
        ClassIndex.getAnnotated(CachedEnum.class).forEach(enumClass -> {
            CachedEnum annotation = enumClass.getAnnotation(CachedEnum.class);
            if (annotation != null) {
                if (ICachedEnum.class.isAssignableFrom((Class<?>)enumClass)) {
                    cache.put(enumClass.getName(), ClassUtils.getEnumValues(enumClass));
                } else {
                    throw new RuntimeException("Found marked with CachedEnum annotation class, but without ICachedEnum implementation: " + enumClass.getSimpleName());
                }
            }
        });
        log.info("Initialized [{}] cached enums.", (Object)cache.size());
    }

    public List<Enum<?>> getEnumValues(String enumClassName) {
        return cache.get(enumClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static CachedEnumService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    CachedEnumService actualValue = new CachedEnumService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (CachedEnumService)($value == instance ? null : $value);
    }
}

