/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.utils.VMUtils;
import host.anzo.core.config.MailConfig;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class MailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private Session session;

    MailService() {
        if (!MailConfig.ENABLE) {
            return;
        }
        Properties mailProps = System.getProperties();
        mailProps.put("mail.transport.protocol", "smtp");
        mailProps.put("mail.smtp.host", MailConfig.SMTP_HOST);
        mailProps.put("mail.smtp.port", (Object)MailConfig.SMTP_PORT);
        mailProps.put("mail.smtp.socketFactory.port", (Object)MailConfig.SMTP_PORT);
        mailProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        mailProps.put("mail.smtp.socketFactory.fallback", "false");
        mailProps.put("mail.smtp.auth", "true");
        this.session = Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(this){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailConfig.USER, MailConfig.PASSWORD);
            }
        });
        if (VMUtils.DEBUG) {
            this.session.setDebug(true);
        }
    }

    public void sendMail(@NotNull String email, @NotNull String subject, @NotNull String messageText) {
        this.sendMail(Collections.singletonList(email), subject, messageText);
    }

    public void sendMail(@NotNull Collection<String> emails, @NotNull String subject, @NotNull String messageText) {
        if (emails.isEmpty()) {
            return;
        }
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(MailConfig.USER));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emails.iterator().next()));
            if (emails.size() > 1) {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)String.join((CharSequence)",", emails)));
            }
            message.setSubject(subject, "UTF-8");
            MimeMultipart messageMultipart = new MimeMultipart();
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)messageText, "text/html");
            messageMultipart.addBodyPart((BodyPart)htmlPart);
            message.setContent((Multipart)messageMultipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            log.error("Error while sending mail", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static MailService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    MailService actualValue = new MailService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (MailService)($value == instance ? null : $value);
    }
}

