package host.anzo.commons.model.enums;

import org.jetbrains.annotations.NotNull;

/**
 * @author ANZO
 * @since 5/28/2024
 */
public enum ERestrictionType {
	BYPASS, // Do nothing
	DROP,   // Just stop action
	LOG,    // Log restricted action (+DROP)
	JAIL,   // Move player to jail (+DROP)
	KICK,   // Kick from game
	BAN;    // Ban account

	public boolean isBypass() {
		return this == BYPASS;
	}

	public boolean isBan() {
		return this == BAN;
	}

	public boolean isKick() {
		return this == KICK;
	}

	public boolean isLog() {
		return this == LOG;
	}

	public boolean isEqualOrHigher(@NotNull ERestrictionType action) {
		return ordinal() >= action.ordinal();
	}
}