/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.socials.telegram;

import host.anzo.commons.graphics.text.TextAlignment;
import host.anzo.commons.graphics.text.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient;
import org.telegram.telegrambots.longpolling.util.LongPollingSingleThreadUpdateConsumer;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.generics.TelegramClient;

public abstract class ATelegramBot
implements LongPollingSingleThreadUpdateConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ATelegramBot.class);
    protected TelegramClient client;
    protected String botName;
    protected String token;
    protected static Font FONT_TITLE;
    protected static Font FONT_CONTENT;
    protected static final int MAX_MESSAGE_SIZE = 4096;
    protected static final int MAX_CAPTION_SIZE = 1024;
    private final ConcurrentHashMap<Runnable, Long> failedToSendMessages = new ConcurrentHashMap();

    public ATelegramBot(String botName, String token) {
        this.token = token;
        this.botName = botName;
        this.client = new OkHttpTelegramClient(token);
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("strongsword_text.ttf");){
            if (is == null) {
                log.error("Can't read font for TelegramService from resources!");
                return;
            }
            Font font = Font.createFont(0, is);
            FONT_TITLE = font.deriveFont(1, 25.0f);
            FONT_CONTENT = font.deriveFont(12.5f);
        }
        catch (Exception e) {
            log.error("Error while loading font", (Throwable)e);
        }
    }

    public void onTick() {
        for (Map.Entry<Runnable, Long> entry : this.failedToSendMessages.entrySet()) {
            if (entry.getValue() > System.currentTimeMillis()) continue;
            this.failedToSendMessages.remove(entry.getKey());
            try {
                entry.getKey().run();
            }
            catch (Exception e) {
                log.error("Error while resend message", (Throwable)e);
            }
        }
    }

    protected abstract InlineKeyboardMarkup getInlineKeyboardMarkup(Update var1);

    protected abstract ReplyKeyboardMarkup getReplyKeyboardMarkup();

    protected abstract String getDefaultBackgroundImagePath();

    protected abstract void onServerShutdown();

    public abstract boolean isEnabled();

    protected void sendMessage(SendMessage message) {
        try {
            this.client.executeAsync((BotApiMethod)message);
        }
        catch (TelegramApiException telegramApiException) {
            // empty catch block
        }
    }

    protected void sendMessage(String chatId, String messageText) {
        if (StringUtils.isEmpty((CharSequence)chatId)) {
            return;
        }
        SendMessage message = SendMessage.builder().parseMode("Markdown").chatId(chatId).text(StringUtils.abbreviate((String)messageText, (int)4096)).build();
        this.sendMessage(message);
    }

    protected void sendMessage(Update update, Long chatId, String messageText, boolean withInlineKeyboard) {
        InlineKeyboardMarkup markupInline;
        if (chatId == null) {
            return;
        }
        SendMessage message = SendMessage.builder().parseMode("Markdown").chatId(Long.toString(chatId)).text(StringUtils.abbreviate((String)messageText, (int)4096)).build();
        if (withInlineKeyboard && (markupInline = this.getInlineKeyboardMarkup(update)) != null) {
            message.setReplyMarkup((ReplyKeyboard)markupInline);
        }
        this.sendMessage(message);
    }

    protected void sendMessage(Long chatId, String title, String messageText, String additionalImagePath) {
        if (chatId == null) {
            return;
        }
        try (InputStream imageStream = this.drawMessageImage(title, messageText, additionalImagePath);){
            if (imageStream == null) {
                return;
            }
            SendPhoto photo = SendPhoto.builder().chatId(Long.toString(chatId)).photo(new InputFile(imageStream, title)).build();
            ReplyKeyboardMarkup replyKeyboardMarkup = this.getReplyKeyboardMarkup();
            if (replyKeyboardMarkup != null) {
                photo.setReplyMarkup((ReplyKeyboard)replyKeyboardMarkup);
            }
            this.client.execute(photo);
        }
        catch (Exception e) {
            log.error("Error while sendMessage", (Throwable)e);
        }
    }

    protected void sendMessage(Long chatId, String title, String messageText, String caption, String additionalImagePath) {
        if (chatId == null) {
            return;
        }
        this.sendMessage(Long.toString(chatId), title, messageText, caption, additionalImagePath);
    }

    protected void sendMessage(String chatId, String title, String messageText, String caption, String additionalImagePath) {
        if (StringUtils.isEmpty((CharSequence)chatId)) {
            return;
        }
        try (InputStream imageStream = this.drawMessageImage(title, messageText, additionalImagePath);){
            if (imageStream == null) {
                return;
            }
            SendPhoto photo = SendPhoto.builder().parseMode("Markdown").chatId(chatId).photo(new InputFile(imageStream, title)).build();
            if (caption.length() <= 1024) {
                photo.setCaption(caption);
                this.client.execute(photo);
            } else {
                this.client.execute(photo);
                SendMessage message = SendMessage.builder().parseMode("Markdown").chatId(chatId).text(StringUtils.abbreviate((String)caption, (int)4096)).build();
                this.client.execute((BotApiMethod)message);
            }
        }
        catch (TelegramApiRequestException e) {
            if (e.getErrorCode() == 429) {
                int retrySeconds = e.getParameters().getRetryAfter();
                if (retrySeconds > 0) {
                    this.addResendTask(() -> this.sendMessage(chatId, title, messageText, caption, additionalImagePath), retrySeconds);
                }
                log.warn("Can't sendMessage title=[{}] messageText=[{}] caption=[{}] additionalImagePath=[{}] apiResponse=[{}]", new Object[]{title, messageText, caption, additionalImagePath, e.getApiResponse()});
            } else {
                log.error("Error while sendMessage title=[{}] messageText=[{}] caption=[{}] additionalImagePath=[{}] apiResponse=[{}]", new Object[]{title, messageText, caption, additionalImagePath, e.getApiResponse(), e});
            }
        }
        catch (Exception e) {
            log.error("Error while sendMessage title=[{}] messageText=[{}] caption=[{}] additionalImagePath=[{}]", new Object[]{title, messageText, caption, additionalImagePath, e});
        }
    }

    protected void deleteMessage(String chatId, @NotNull Message message) {
        DeleteMessage deleteMessage = DeleteMessage.builder().chatId(chatId).messageId(message.getMessageId()).build();
        try {
            this.client.executeAsync((BotApiMethod)deleteMessage);
        }
        catch (TelegramApiException telegramApiException) {
            // empty catch block
        }
    }

    @Nullable
    private InputStream drawMessageImage(String title, String messageText, String additionalImagePath) {
        ByteArrayInputStream byteArrayInputStream;
        BufferedImage image = ImageIO.read(new File(this.getDefaultBackgroundImagePath()));
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setFont(FONT_TITLE);
        graphics.setColor(Color.WHITE);
        graphics.drawString(title.toUpperCase(), 10, 30);
        graphics.drawLine(10, 40, 330, 40);
        Rectangle bounds = new Rectangle(10, 50, 330, 75);
        TextRenderer.drawString(graphics, messageText, FONT_CONTENT, Color.WHITE, bounds, TextAlignment.TOP_LEFT, 0);
        File additionalImageFile = new File(additionalImagePath);
        if (additionalImageFile.exists()) {
            BufferedImage additionalImage = ImageIO.read(additionalImageFile);
            graphics.drawImage((Image)additionalImage, 345, 30, null);
        }
        graphics.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error while drawMessageImage", (Throwable)e);
                return null;
            }
        }
        outputStream.close();
        return byteArrayInputStream;
    }

    protected void addResendTask(Runnable runnable, int retryAfterSeconds) {
        this.failedToSendMessages.put(runnable, System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(retryAfterSeconds));
    }

    public void consume(Update update) {
    }

    @Generated
    public String getBotName() {
        return this.botName;
    }

    @Generated
    public String getToken() {
        return this.token;
    }
}

