/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.socials.telegram;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.socials.telegram.ATelegramBot;
import host.anzo.commons.socials.telegram.TelegramBot;
import host.anzo.core.startup.IShutdownable;
import host.anzo.core.startup.Scheduled;
import host.anzo.core.startup.StartupComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;

@StartupComponent(value="Service")
public class TelegramService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final TelegramBotsLongPollingApplication botsApplication = new TelegramBotsLongPollingApplication();
    private static final Map<Class<?>, ATelegramBot> registeredBots = new HashMap();

    public TelegramService() {
        try {
            for (Class clazz : ClassIndex.getAnnotated(TelegramBot.class)) {
                try {
                    ATelegramBot bot = (ATelegramBot)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!bot.isEnabled()) continue;
                    registeredBots.put(clazz, bot);
                    botsApplication.registerBot(bot.getToken(), (LongPollingUpdateConsumer)bot);
                    log.info("Registered [{}] telegram bot", (Object)bot.getBotName());
                }
                catch (Exception e) {
                    log.error("Error while bot registration with class=[{}]", (Object)clazz.getSimpleName());
                }
            }
        }
        catch (Exception e) {
            log.error("Error while initialize Telegram bot session", (Throwable)e);
        }
    }

    @Scheduled(period=10L, timeUnit=TimeUnit.SECONDS, runAfterServerStart=true)
    public void tickTask() {
        registeredBots.values().forEach(ATelegramBot::onTick);
    }

    public <T extends ATelegramBot> T getBot(Class<T> botClass) {
        return (T)registeredBots.get(botClass);
    }

    @Override
    public void onShutdown() {
        registeredBots.values().forEach(ATelegramBot::onServerShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static TelegramService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    TelegramService actualValue = new TelegramService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (TelegramService)($value == instance ? null : $value);
    }
}

