package host.anzo.commons.utils;

import host.anzo.commons.text.formatters.RoundedMetricPrefixFormat;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

/**
 * @author ANZO
 * @since 9/8/2021
 */
public class NumberUtilsEx extends NumberUtils {
    private final static RoundedMetricPrefixFormat ROUNDED_METRIC_PREFIX_FORMAT = new RoundedMetricPrefixFormat();

    /**
     * @param number number to convert
     * @return number string in <a href="http://en.wikipedia.org/wiki/Metric_prefix">metric prefix</a> format.
     */
    public static @NotNull String toMetricPrefixedString(Number number) {
        return ROUNDED_METRIC_PREFIX_FORMAT.format(number);
    }

    /**
     * Pack to integers to long
     * @param int1 first int
     * @param int2 second int
     * @return long number with two specified packed integers
     */
    public static long packIntsToLong(int int1, int int2) {
	    return ((long) int1 << 32) | (int2 & 0xFFFFFFFFL);
    }

    /**
     * Unpack two integers from specified long number
     * @param packedValue long number
     * @return pair of two unpacked integers
     */
    public static Pair<Integer, Integer> unpackIntsFromLong(long packedValue) {
        final int int1 = (int) (packedValue >> 32);
        final int int2 = (int) packedValue;
        return Pair.of(int1, int2);
    }

    /**
     * Safe cast long to integer value
     * @param value long value
     * @return valid integer value
     */
    public static int checkedCast(long value) {
        return Math.clamp(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }
}
