/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.datetime;

import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StopWatch {
    private long startTime = System.nanoTime();
    private long point = 0L;
    private long pointTemp;

    public void pointStart() {
        this.pointTemp = System.nanoTime();
    }

    public void pointEnd() {
        this.point += System.nanoTime() - this.pointTemp;
    }

    public void pointRestart() {
        this.point = 0L;
    }

    public String pointResult() {
        return this.formatLong(this.pointResultNanos());
    }

    public String pointResult(long mul) {
        return this.formatLong(this.pointResultNanos(mul));
    }

    public long pointResultNanos() {
        return this.point;
    }

    public long pointResultNanos(long mul) {
        return this.point / mul;
    }

    public String pointResultAndRestart() {
        long out = this.pointResultNanos();
        this.pointRestart();
        return this.formatLong(out);
    }

    public String pointResultAndRestart(long mul) {
        long out = this.pointResultNanos(mul);
        this.pointRestart();
        return this.formatLong(out);
    }

    public void restart() {
        this.startTime = System.nanoTime();
    }

    public long result(@NotNull TimeUnit timeUnit) {
        return timeUnit.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }

    public String result() {
        return this.formatLong(this.result(TimeUnit.NANOSECONDS));
    }

    public String resultAndRestart() {
        long out = this.result(TimeUnit.NANOSECONDS);
        this.restart();
        return this.formatLong(out);
    }

    @NotNull
    private String formatLong(long nanos) {
        if (TimeUnit.NANOSECONDS.toSeconds(nanos) > 1L) {
            return (double)TimeUnit.NANOSECONDS.toMillis(nanos) / 1000.0 + " s.";
        }
        if (TimeUnit.NANOSECONDS.toMillis(nanos) > 1L) {
            return (double)TimeUnit.NANOSECONDS.toMicros(nanos) / 1000.0 + " ms.";
        }
        return (double)nanos / 1000000.0 + " ms.";
    }

    public String toString() {
        return "Timer: start at " + this.startTime + "/" + this.result() + " ago. / Point: " + this.point;
    }
}

