/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSplitter<T> {
    private List<T> objects;
    private int splitCount;
    private int currentIndex = 0;

    public ListSplitter(Collection<T> collection, int splitCount) {
        if (collection != null) {
            this.splitCount = splitCount;
            this.objects = new ArrayList<T>(collection);
        }
    }

    public List<T> getNext(int splitCount) {
        this.splitCount = splitCount;
        return this.getNext();
    }

    public List<T> getNext() {
        int chunkSize = Math.min(this.splitCount, this.objects.size() - this.currentIndex);
        List<T> chunk = this.objects.subList(this.currentIndex, this.currentIndex + chunkSize);
        this.currentIndex += chunkSize;
        return chunk;
    }

    public int size() {
        return this.objects.size();
    }

    public boolean isFirst() {
        return this.currentIndex <= this.splitCount;
    }

    public boolean isLast() {
        return this.currentIndex == this.objects.size();
    }

    public boolean hasNext() {
        return this.currentIndex < this.objects.size();
    }
}

