/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemdUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemdUtils.class);

    public static void notifyReady() {
        SystemdUtils.notify("--ready");
    }

    public static void setStatus(String status) {
        SystemdUtils.notify("--status=" + status);
    }

    private static void notify(String param) {
        if (System.getenv("NOTIFY_SOCKET") == null) {
            return;
        }
        try {
            Process process = new ProcessBuilder("systemd-notify", param).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                log.error("Can't notify systemd exitCode={}", (Object)exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Can't notify systemd", (Throwable)e);
        }
    }
}

