/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.emergency.memory;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.annotations.startup.Scheduled;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.emergency.memory.IMemoryListener;
import host.anzo.commons.emergency.memory.watchers.DefaultWatcher;
import host.anzo.commons.emergency.memory.watchers.G1Watcher;
import host.anzo.commons.emergency.memory.watchers.IMemoryWatcher;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.commons.utils.VMUtils;
import host.anzo.core.config.EmergencyConfig;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import lombok.Generated;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metric
@StartupComponent(value="Diagnostic")
public class MemoryLeakDetector
implements NotificationListener,
IMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryLeakDetector.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final PropertyNode metrics = Metrics.create();
    private final List<IMemoryListener> listeners = new ArrayList<IMemoryListener>();
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("H:mm:ss");
    private final DecimalFormat percentFormat = new DecimalFormat(" (0.0000'%')");
    private final DecimalFormat sizeFormat = new DecimalFormat(" # 'KB'");

    private MemoryLeakDetector() {
        List<IMemoryWatcher> watchers = Arrays.asList(new G1Watcher(), new DefaultWatcher());
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            watchers.stream().filter(watcher -> watcher.isValid(pool)).forEach(watcher -> watcher.register(pool));
            log.info("Watcher for memory pool [{}] successfully registered.", (Object)pool.getName());
        }
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            try {
                ManagementFactory.getPlatformMBeanServer().addNotificationListener(gcBean.getObjectName(), this, null, null);
            }
            catch (Exception e) {
                log.error("Error while register GC notification listener", (Throwable)e);
            }
        }
    }

    @Scheduled(period=10L, timeUnit=TimeUnit.MINUTES, runAfterServerStart=true)
    public void reportMemoryStats() {
        for (String memStat : this.getMemoryUsageStatistics()) {
            log.info(memStat);
        }
        log.info("Memory Pool Information:");
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            log.info("- {} : {}", (Object)pool.getName(), (Object)pool.getUsage().toString());
        }
        log.info("Bytebuffer Pool Information:");
        for (BufferPoolMXBean pool : VMUtils.getByteBufferPools()) {
            log.info("- {}: count={} usedMemory={} totalCapacity={}", new Object[]{pool.getName(), pool.getCount(), pool.getMemoryUsed(), pool.getTotalCapacity()});
        }
    }

    @Override
    public void handleNotification(@NotNull Notification notification, Object handback) {
        if (notification.getType().equals("com.sun.management.gc.notification") && EmergencyConfig.ENABLE_METRICS) {
            CompositeData cd = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo gcNotificationInfo = GarbageCollectionNotificationInfo.from(cd);
            GcInfo gcInfo = gcNotificationInfo.getGcInfo();
            String gcActionName = gcNotificationInfo.getGcAction().replace(" ", "_");
            metrics.record(Metrics.happened((String)("gc_" + gcActionName + "_count")));
            metrics.record(Metrics.value((String)("gc_" + gcActionName + "_time"), (long)gcInfo.getDuration()));
            metrics.record(Metrics.value((String)("gc_" + gcActionName + "_cleaned_mb"), (long)Math.max(0L, MemoryLeakDetector.sumUsedMb(gcInfo.getMemoryUsageBeforeGc()) - MemoryLeakDetector.sumUsedMb(gcInfo.getMemoryUsageAfterGc()))));
        }
    }

    private static long sumUsedMb(@NotNull Map<String, MemoryUsage> memUsages) {
        long sum = 0L;
        for (MemoryUsage memoryUsage : memUsages.values()) {
            sum += memoryUsage.getUsed();
        }
        return sum / 0x100000L;
    }

    public void registerListener(IMemoryListener listener) {
        this.listeners.add(listener);
    }

    public void onMemoryLeakDetected() {
        this.listeners.forEach(IMemoryListener::onMemoryLeakDetected);
    }

    public String getStats() {
        TextStringBuilder builder = new TextStringBuilder();
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            builder.appendln(pool.getName() + " : " + pool.getUsage().toString());
        }
        return builder.get();
    }

    public String @NotNull [] getMemoryUsageStatistics() {
        double max = (double)Runtime.getRuntime().maxMemory() / 1024.0;
        double allocated = (double)Runtime.getRuntime().totalMemory() / 1024.0;
        double nonAllocated = max - allocated;
        double cached = (double)Runtime.getRuntime().freeMemory() / 1024.0;
        double used = allocated - cached;
        double usable = max - used;
        return new String[]{"+----", "| Global Memory Information at " + this.timeFormat.format(new Date()) + ":", "|    |", "| Allowed Memory:" + this.sizeFormat.format(max), "|    |= Allocated Memory:" + this.sizeFormat.format(allocated) + this.percentFormat.format(allocated / max * 100.0), "|    |= Non-Allocated Memory:" + this.sizeFormat.format(nonAllocated) + this.percentFormat.format(nonAllocated / max * 100.0), "| Allocated Memory:" + this.sizeFormat.format(allocated), "|    |= Used Memory:" + this.sizeFormat.format(used) + this.percentFormat.format(used / max * 100.0), "|    |= Unused (cached) Memory:" + this.sizeFormat.format(cached) + this.percentFormat.format(cached / max * 100.0), "| Usable Memory:" + this.sizeFormat.format(usable) + this.percentFormat.format(usable / max * 100.0), "+----"};
    }

    @Override
    public List<MetricResult> getMetric() {
        MetricResult result = new MetricResult();
        result.setMetricGroupType(MetricGroupType.SYSTEM);
        result.setName("MemoryService");
        result.setData((String)metrics.render().get());
        return Collections.singletonList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static MemoryLeakDetector getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    MemoryLeakDetector actualValue = new MemoryLeakDetector();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (MemoryLeakDetector)($value == instance ? null : $value);
    }
}

