/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.startup.Scheduled;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.commons.socials.telegram.ATelegramBot;
import host.anzo.commons.socials.telegram.TelegramBot;
import host.anzo.commons.utils.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;

@StartupComponent(value="Service")
public class TelegramService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final TelegramBotsLongPollingApplication botsApplication = new TelegramBotsLongPollingApplication();
    private static final Map<Class<?>, ATelegramBot> registeredBots = new HashMap();
    private static final Set<Long> banned_chats = new TreeSet<Long>();

    public TelegramService() {
        try {
            for (Class clazz : ClassIndex.getAnnotated(TelegramBot.class)) {
                try {
                    ATelegramBot bot = (ATelegramBot)ClassUtils.singletonInstance(clazz);
                    if (bot.isEnabled()) {
                        registeredBots.put(clazz, bot);
                        botsApplication.registerBot(bot.getToken(), (LongPollingUpdateConsumer)bot);
                        log.info("Registered [{}] telegram bot.", (Object)bot.getBotName());
                        continue;
                    }
                    log.info("Skipped [{}] telegram bot because disabled by configuration.", (Object)bot.getBotName());
                }
                catch (Exception e) {
                    log.error("Error while bot registration with class=[{}]", (Object)clazz.getSimpleName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Error while initialize Telegram bot session", (Throwable)e);
        }
    }

    public void banChatId(long chatId) {
        banned_chats.add(chatId);
        log.warn("Banned chat id: {}", (Object)chatId);
    }

    public boolean isChatBanned(long chatId) {
        return banned_chats.contains(chatId);
    }

    @Scheduled(period=10L, timeUnit=TimeUnit.SECONDS, runAfterServerStart=true)
    public void tickTask() {
        banned_chats.clear();
        registeredBots.values().forEach(ATelegramBot::onTick);
    }

    public <T extends ATelegramBot> T getBot(Class<T> botClass) {
        return (T)registeredBots.get(botClass);
    }

    public void onShutdown() {
        registeredBots.values().forEach(ATelegramBot::onServerShutdown);
        try {
            botsApplication.close();
        }
        catch (Exception e) {
            log.error("Error while closing Telegram bot session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static TelegramService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    TelegramService actualValue = new TelegramService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (TelegramService)($value == instance ? null : $value);
    }
}

