/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.webserver.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import spark.Response;

public class JsonResultBuilder {
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private Response response;

    public JsonResultBuilder() {
    }

    public JsonResultBuilder(@NotNull Response response) {
        response.type("application/json");
        this.response = response;
    }

    public JsonResultBuilder(@NotNull Response response, int resultCode) {
        this(response);
        this.params.put("resultCode", resultCode);
        this.params.put("result", resultCode);
    }

    public JsonResultBuilder with(String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    public JsonResultBuilder withString(String key, @NotNull Object value) {
        this.params.put(key, value.toString());
        return this;
    }

    public JsonResultBuilder withStatus(int status) {
        if (this.response != null) {
            this.response.status(status);
        }
        return this;
    }

    public String build() {
        TextStringBuilder builder = new TextStringBuilder("{");
        int paramCount = this.params.size();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            --paramCount;
            builder.append("\"").append(entry.getKey()).append("\" : ");
            if (entry.getValue() instanceof String) {
                builder.append("\"").append(entry.getValue()).append("\"");
            } else {
                builder.append(entry.getValue());
            }
            if (paramCount <= 0) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.build();
    }

    public String toString() {
        return this.build();
    }
}

