package host.anzo.commons.emergency.memory;

import host.anzo.commons.utils.VMUtils;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author ANZO
 * @since 12.02.2017
 */
public class MemoryHeapDumper {
	private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");

	/**
	 * Create memory dump file
	 * @param dumpsDir dump directory
	 * @param live dump only "live" objects
	 */
	public static @NotNull String dumpHeap(String dumpsDir, boolean live) {
		try {
			String fullPath = dumpsDir + "/";
			new File(fullPath).mkdirs();
			fullPath += formatter.format(new Date());
			if (live) {
				fullPath += ".live";
			}
			fullPath += ".hprof";
			VMUtils.getBean().dumpHeap(fullPath, live);
			return fullPath;
		} catch (RuntimeException re) {
			throw re;
		} catch (Exception exp) {
			throw new RuntimeException(exp);
		}
	}
}