/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.collection;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsSet
implements Map<String, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatsSet.class);
    @NotNull
    private final Map<String, Object> internalMap;

    public StatsSet(@NotNull Supplier<Map<String, Object>> mapFactory) {
        this(mapFactory.get());
    }

    private StatsSet(@NotNull Map<String, Object> map) {
        this.internalMap = map;
    }

    public static StatsSet wrap(@NotNull Map<String, Object> map) {
        return new StatsSet(map);
    }

    public static StatsSet parseParams(@Nullable String params, @NotNull String splitter1, @NotNull String splitter2, @NotNull Supplier<Map<String, Object>> mapFactory) {
        Map<String, Object> map = mapFactory.get();
        if (params != null) {
            try {
                String[] args;
                for (String split : args = params.split(splitter1)) {
                    map.put(split.split(splitter2)[0], split.split(splitter2)[1]);
                }
            }
            catch (Exception e) {
                log.error("Can't parse params: {}", (Object)params, (Object)e);
            }
        }
        return StatsSet.wrap(map);
    }

    public boolean getBooleanOrThrow(@NotNull String key) throws IllegalArgumentException {
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Boolean b = (Boolean)object;
                yield b;
            }
            case 1 -> {
                String s = (String)object;
                yield Boolean.parseBoolean(s);
            }
            case -1 -> throw new IllegalArgumentException("Boolean value required, but not found: " + key);
            default -> throw new IllegalArgumentException("Boolean value required, but not specified: " + key + " = " + String.valueOf(val));
        };
    }

    public boolean getBooleanOrDefault(@NotNull String key, boolean defaultValue) {
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Boolean b = (Boolean)object;
                yield b;
            }
            case 1 -> {
                String s = (String)object;
                yield Boolean.parseBoolean(s);
            }
            default -> defaultValue;
        };
    }

    public byte getByteOrThrow(@NotNull String key) throws IllegalArgumentException {
        byte by;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    by = n2.byteValue();
                    break block5;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block5;
                    }
                    by = Byte.parseByte(s);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Byte value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Byte value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return by;
    }

    public byte getByteOrDefault(@NotNull String key, byte defaultValue) {
        byte by;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    by = n2.byteValue();
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block4;
                    }
                    by = Byte.parseByte(s);
                    break block4;
                }
                default: {
                    by = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return by;
    }

    public short getShortOrThrow(@NotNull String key) throws IllegalArgumentException {
        short s;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    s = n2.shortValue();
                    break block5;
                }
                case 1: {
                    String s2 = (String)object;
                    if (!NumberUtils.isParsable((String)s2)) {
                        n = 2;
                        continue block5;
                    }
                    s = Short.parseShort(s2);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Short value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Short value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return s;
    }

    public short getShortOrDefault(@NotNull String key, short defaultValue) {
        short s;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    s = n2.shortValue();
                    break block4;
                }
                case 1: {
                    String s2 = (String)object;
                    if (!NumberUtils.isParsable((String)s2)) {
                        n = 2;
                        continue block4;
                    }
                    s = Short.parseShort(s2);
                    break block4;
                }
                default: {
                    s = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return s;
    }

    public int getIntOrThrow(@NotNull String key) throws IllegalArgumentException {
        int n;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n2 = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n2)) {
                case 0: {
                    Number n3 = (Number)object;
                    n = n3.intValue();
                    break block5;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n2 = 2;
                        continue block5;
                    }
                    n = Integer.parseInt(s);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Integer value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Integer value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return n;
    }

    public int getIntOrDefault(@NotNull String key, int defaultValue) {
        int n;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n2)) {
                case 0: {
                    Number n3 = (Number)object;
                    n = n3.intValue();
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n2 = 2;
                        continue block4;
                    }
                    n = Integer.parseInt(s);
                    break block4;
                }
                default: {
                    n = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return n;
    }

    public long getLongOrThrow(@NotNull String key) throws IllegalArgumentException {
        long l;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    l = n2.longValue();
                    break block5;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block5;
                    }
                    l = Long.parseLong(s);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Long value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Long value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return l;
    }

    public long getLongOrDefault(@NotNull String key, long defaultValue) {
        long l;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    l = n2.longValue();
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block4;
                    }
                    l = Long.parseLong(s);
                    break block4;
                }
                default: {
                    l = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return l;
    }

    public float getFloatOrThrow(@NotNull String key) throws IllegalArgumentException {
        float f;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    f = n2.floatValue();
                    break block5;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block5;
                    }
                    f = Float.parseFloat(s);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Float value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Float value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return f;
    }

    public float getFloatOrDefault(@NotNull String key, float defaultValue) {
        float f;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    f = n2.floatValue();
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block4;
                    }
                    f = Float.parseFloat(s);
                    break block4;
                }
                default: {
                    f = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return f;
    }

    public double getDoubleOrThrow(@NotNull String key) throws IllegalArgumentException {
        double d;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    d = n2.doubleValue();
                    break block5;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block5;
                    }
                    d = Double.parseDouble(s);
                    break block5;
                }
                case -1: {
                    throw new IllegalArgumentException("Double value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Double value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return d;
    }

    public double getDoubleOrDefault(@NotNull String key, double defaultValue) {
        double d;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case 0: {
                    Number n2 = (Number)object;
                    d = n2.doubleValue();
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    if (!NumberUtils.isParsable((String)s)) {
                        n = 2;
                        continue block4;
                    }
                    d = Double.parseDouble(s);
                    break block4;
                }
                default: {
                    d = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return d;
    }

    @NotNull
    public String getStringOrThrow(@NotNull String key) throws IllegalArgumentException {
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)object, n)) {
            case -1 -> throw new IllegalArgumentException("String value required, but not found: " + key);
            case 0 -> {
                String s;
                yield s = (String)object;
            }
            default -> String.valueOf(val);
        };
    }

    @Nullable
    public String getStringOrDefault(@NotNull String key, @Nullable String defaultValue) {
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)object, n)) {
            case -1 -> defaultValue;
            case 0 -> {
                String s;
                yield s = (String)object;
            }
            default -> String.valueOf(val);
        };
    }

    @NotNull
    public <T extends Enum<T>> T getEnumOrThrow(@NotNull String key, @NotNull Class<T> enumClass) throws IllegalArgumentException {
        Enum enum_;
        Object val;
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Invalid enum class: " + String.valueOf(enumClass));
        }
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object.class, String.class}, (Object)object, n)) {
                case 0: {
                    Object o = object;
                    if (!enumClass.isInstance(o)) {
                        n = 1;
                        continue block4;
                    }
                    enum_ = (Enum)enumClass.cast(o);
                    break block4;
                }
                case 1: {
                    String s = (String)object;
                    enum_ = (Enum)Enum.valueOf(enumClass, s);
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but not found: " + key);
                }
            }
            break;
        }
        return (T)enum_;
    }

    @Nullable
    public <T extends Enum<T>> T getEnumOrDefault(@NotNull String key, @NotNull Class<T> enumClass, @Nullable T defaultValue, @Nullable String start, @Nullable String end) {
        Object object;
        Object val;
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Invalid enum class: " + String.valueOf(enumClass));
        }
        Object object2 = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object.class, String.class}, (Object)object2, n)) {
                case 0: {
                    Object o = object2;
                    if (!enumClass.isInstance(o)) {
                        n = 1;
                        continue block4;
                    }
                    object = (Enum)enumClass.cast(o);
                    break block4;
                }
                case 1: {
                    String s = (String)object2;
                    object = (Enum)Enum.valueOf(enumClass, StatsSet.cleanse(s, start, end));
                    break block4;
                }
                default: {
                    object = defaultValue;
                    break block4;
                }
            }
            break;
        }
        return object;
    }

    @Nullable
    public Object getRawObject(@NotNull String key) {
        return this.internalMap.get(key);
    }

    @NotNull
    public <A> A getObjectOrThrow(@NotNull String key, @NotNull Class<A> type) throws IllegalArgumentException {
        Object o;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object.class}, (Object)object, n)) {
                case 0: {
                    o = object;
                    if (type.isInstance(o)) break block4;
                    n = 1;
                    continue block4;
                }
                case -1: {
                    throw new IllegalArgumentException("Object value required, but not found: " + key);
                }
                default: {
                    throw new IllegalArgumentException("Object value required, but not specified: " + key + " = " + String.valueOf(val));
                }
            }
            break;
        }
        return type.cast(o);
    }

    @Nullable
    public <A> A getObjectOrDefault(@NotNull String key, @NotNull Class<A> type, @Nullable A defaultValue) {
        A a;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object.class}, (Object)object, n)) {
                case 0: {
                    Object o = object;
                    if (!type.isInstance(o)) {
                        n = 1;
                        continue block3;
                    }
                    a = type.cast(o);
                    break block3;
                }
                default: {
                    a = defaultValue;
                    break block3;
                }
            }
            break;
        }
        return a;
    }

    public boolean @NotNull [] getParsedBooleanArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        boolean[] blArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, Boolean[].class, Boolean.class, String.class}, (Object)object, n)) {
            case 0: {
                boolean[] v;
                blArray = v = (boolean[])object;
                break;
            }
            case 1: {
                Boolean[] v = (Boolean[])object;
                blArray = ArrayUtils.toPrimitive((Boolean[])v);
                break;
            }
            case 2: {
                Boolean v = (Boolean)object;
                boolean[] blArray2 = new boolean[1];
                blArray = blArray2;
                blArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                blArray = ArrayUtils.toPrimitive((Boolean[])((Boolean[])Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).map(Boolean::parseBoolean).toArray(Boolean[]::new)));
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Boolean value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Boolean value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return blArray;
    }

    public char @NotNull [] getParsedCharArrayOrThrow(@NotNull String key, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        char[] cArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{char[].class, Character[].class, Character.class, String.class}, (Object)object, n)) {
            case 0: {
                char[] v;
                cArray = v = (char[])object;
                break;
            }
            case 1: {
                Character[] v = (Character[])object;
                cArray = ArrayUtils.toPrimitive((Character[])v);
                break;
            }
            case 2: {
                Character v = (Character)object;
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = v.charValue();
                break;
            }
            case 3: {
                String s = (String)object;
                cArray = StatsSet.cleanse(s, start, end).toCharArray();
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Character value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Character value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return cArray;
    }

    public byte @NotNull [] getParsedByteArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        byte[] byArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, Byte[].class, Byte.class, String.class}, (Object)object, n)) {
            case 0: {
                byte[] v;
                byArray = v = (byte[])object;
                break;
            }
            case 1: {
                Byte[] v = (Byte[])object;
                byArray = ArrayUtils.toPrimitive((Byte[])v);
                break;
            }
            case 2: {
                Byte v = (Byte)object;
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                byArray = ArrayUtils.toPrimitive((Byte[])((Byte[])Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).map(Byte::parseByte).toArray(Byte[]::new)));
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Byte value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Byte value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return byArray;
    }

    public short @NotNull [] getParsedShortArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        short[] sArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{short[].class, Short[].class, Short.class, String.class}, (Object)object, n)) {
            case 0: {
                short[] a;
                sArray = a = (short[])object;
                break;
            }
            case 1: {
                Short[] a = (Short[])object;
                sArray = ArrayUtils.toPrimitive((Short[])a);
                break;
            }
            case 2: {
                Short v = (Short)object;
                short[] sArray2 = new short[1];
                sArray = sArray2;
                sArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                sArray = ArrayUtils.toPrimitive((Short[])((Short[])Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).map(Short::parseShort).toArray(Short[]::new)));
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Short value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Short value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return sArray;
    }

    public int @NotNull [] getParsedIntArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        int[] nArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, Integer[].class, Integer.class, String.class}, (Object)object, n)) {
            case 0: {
                int[] a;
                nArray = a = (int[])object;
                break;
            }
            case 1: {
                Integer[] a = (Integer[])object;
                nArray = ArrayUtils.toPrimitive((Integer[])a);
                break;
            }
            case 2: {
                Integer v = (Integer)object;
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                nArray = Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).mapToInt(Integer::parseInt).toArray();
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Integer value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Integer value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return nArray;
    }

    public long @NotNull [] getParsedLongArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        long[] lArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{long[].class, Long[].class, Long.class, String.class}, (Object)object, n)) {
            case 0: {
                long[] a;
                lArray = a = (long[])object;
                break;
            }
            case 1: {
                Long[] a = (Long[])object;
                lArray = ArrayUtils.toPrimitive((Long[])a);
                break;
            }
            case 2: {
                Long v = (Long)object;
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                lArray = Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).mapToLong(Long::parseLong).toArray();
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Long value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Long value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return lArray;
    }

    public float @NotNull [] getParsedFloatArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        float[] fArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{float[].class, Float[].class, Float.class, String.class}, (Object)object, n)) {
            case 0: {
                float[] a;
                fArray = a = (float[])object;
                break;
            }
            case 1: {
                Float[] a = (Float[])object;
                fArray = ArrayUtils.toPrimitive((Float[])a);
                break;
            }
            case 2: {
                Float v = (Float)object;
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = v.floatValue();
                break;
            }
            case 3: {
                String s = (String)object;
                fArray = ArrayUtils.toPrimitive((Float[])((Float[])Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).map(Float::parseFloat).toArray(Float[]::new)));
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Float value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Float value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return fArray;
    }

    public double @NotNull [] getParsedDoubleArrayOrThrow(@NotNull String key, @NotNull String splitOn, @Nullable String start, @Nullable String end) throws IllegalArgumentException {
        double[] dArray;
        Object val;
        Object object = val = this.internalMap.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{double[].class, Double[].class, Double.class, String.class}, (Object)object, n)) {
            case 0: {
                double[] a;
                dArray = a = (double[])object;
                break;
            }
            case 1: {
                Double[] a = (Double[])object;
                dArray = ArrayUtils.toPrimitive((Double[])a);
                break;
            }
            case 2: {
                Double v = (Double)object;
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = v;
                break;
            }
            case 3: {
                String s = (String)object;
                dArray = Arrays.stream(StatsSet.cleanse(s, start, end).split(splitOn)).mapToDouble(Double::parseDouble).toArray();
                break;
            }
            case -1: {
                throw new IllegalArgumentException("Double value required, but not found: " + key);
            }
            default: {
                throw new IllegalArgumentException("Double value required, but not specified: " + key + " = " + String.valueOf(val));
            }
        }
        return dArray;
    }

    public void putObject(@NotNull String key, @Nullable Object value) {
        if (value == null) {
            return;
        }
        this.internalMap.put(key, value);
    }

    public void putBoolean(@NotNull String key, boolean value) {
        this.internalMap.put(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putByte(@NotNull String key, byte value) {
        this.internalMap.put(key, value);
    }

    public void putShort(@NotNull String key, short value) {
        this.internalMap.put(key, value);
    }

    public void putInt(@NotNull String key, int value) {
        this.internalMap.put(key, value);
    }

    public void putLong(@NotNull String key, long value) {
        this.internalMap.put(key, value);
    }

    public void putFloat(@NotNull String key, float value) {
        this.internalMap.put(key, Float.valueOf(value));
    }

    public void putDouble(@NotNull String key, double value) {
        this.internalMap.put(key, value);
    }

    public void putString(@NotNull String key, @Nullable String value) {
        if (value == null) {
            return;
        }
        this.internalMap.put(key, value);
    }

    public void putEnum(@NotNull String key, @Nullable Enum<?> value) {
        if (value == null) {
            return;
        }
        this.internalMap.put(key, value);
    }

    public String toString() {
        return "MultiTypesMap{wrapped=" + String.valueOf(this.internalMap) + "}";
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    @Nullable
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    @Nullable
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> map) {
        if (Objects.equals(this.internalMap, map) || map.isEmpty()) {
            return;
        }
        this.internalMap.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.internalMap.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.internalMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.internalMap.replaceAll(function);
    }

    @Override
    @Nullable
    public Object putIfAbsent(String key, Object value) {
        return this.internalMap.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.internalMap.remove(key, value);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.internalMap.replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public Object replace(String key, Object value) {
        return this.internalMap.replace(key, value);
    }

    @Override
    public Object computeIfAbsent(String key, @NotNull Function<? super String, ?> mappingFunction) {
        return this.internalMap.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, @NotNull BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.internalMap.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object compute(String key, @NotNull BiFunction<? super String, ? super @Nullable Object, ?> remappingFunction) {
        return this.internalMap.compute(key, remappingFunction);
    }

    @Override
    public Object merge(String key, @NotNull Object value, @NotNull BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.internalMap.merge(key, value, remappingFunction);
    }

    private static String cleanse(String string, String start, String end) {
        if (string != null && start != null && end != null && string.startsWith(start) && string.endsWith(end)) {
            string = string.substring(start.length(), string.length() - end.length());
        }
        return string;
    }
}

