/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.emergency.metric;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.emergency.metric.IMetric;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.commons.utils.ClassUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.text.TextStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Diagnostic")
public class MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();

    private MetricService() {
    }

    public String getMetrics() {
        TextStringBuilder allBuilder = new TextStringBuilder("{").appendln("\"version\": \"1.0.0\",");
        HashMap metricsResult = new HashMap();
        HashSet parentMetrics = new HashSet();
        ClassIndex.getAnnotated(Metric.class).forEach(clazz -> {
            if (IMetric.class.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                boolean canBeAdded = true;
                Metric metricAnnotation = clazz.getAnnotation(Metric.class);
                if (metricAnnotation.fromParent() && parentMetrics.contains(clazz.getSuperclass())) {
                    canBeAdded = false;
                }
                if (canBeAdded) {
                    Object singletonObject;
                    if (metricAnnotation.fromParent()) {
                        parentMetrics.add(clazz.getSuperclass());
                    }
                    if ((singletonObject = ClassUtils.singletonInstance(clazz)) != null) {
                        List<MetricResult> metrics = ((IMetric)singletonObject).getMetric();
                        for (MetricResult metric : metrics) {
                            metricsResult.computeIfAbsent(metric.getMetricGroupType(), k -> new ArrayList()).add("\"" + metric.getName() + "\" : " + metric.getData());
                        }
                    }
                }
            }
        });
        ArrayList<CallSite> metricGroupResults = new ArrayList<CallSite>();
        for (Map.Entry entry : metricsResult.entrySet()) {
            metricGroupResults.add((CallSite)((Object)("\"" + String.valueOf(entry.getKey()) + "\" : {" + String.join((CharSequence)",", (Iterable)entry.getValue()) + "}")));
        }
        allBuilder.appendln(String.join((CharSequence)",", metricGroupResults));
        allBuilder.appendln("}");
        return allBuilder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static MetricService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    MetricService actualValue = new MetricService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (MetricService)($value == instance ? null : $value);
    }
}

