/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.webserver.engine;

import host.anzo.core.config.WebServerConfig;
import java.util.Locale;
import java.util.Map;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.jetbrains.annotations.NotNull;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import spark.ModelAndView;
import spark.TemplateEngine;

public class ThymeleafTemplateEngine
extends TemplateEngine {
    private final org.thymeleaf.TemplateEngine thymeleaf;

    public ThymeleafTemplateEngine() {
        FileTemplateResolver templateResolver = new FileTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setPrefix(WebServerConfig.DATA_PATH);
        templateResolver.setSuffix(".html");
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        templateResolver.setCacheable(!WebServerConfig.DEBUG);
        this.thymeleaf = new org.thymeleaf.TemplateEngine();
        this.thymeleaf.setTemplateResolver((ITemplateResolver)templateResolver);
        this.thymeleaf.addDialect((IDialect)new LayoutDialect());
    }

    public String render(@NotNull ModelAndView modelAndView) {
        Context ctx = new Context(Locale.getDefault());
        if (modelAndView.getModel() instanceof Map) {
            if (WebServerConfig.DEBUG) {
                for (Object key : ((Map)modelAndView.getModel()).keySet()) {
                    if (key instanceof String) continue;
                    throw new IllegalArgumentException("All keys of the model must be Strings");
                }
            }
            ctx.setVariables((Map)modelAndView.getModel());
            return this.thymeleaf.process(modelAndView.getViewName(), (IContext)ctx);
        }
        ctx.setVariable("model", modelAndView.getModel());
        return this.thymeleaf.process(modelAndView.getViewName(), (IContext)ctx);
    }
}

