package host.anzo.commons.utils;

import host.anzo.commons.enums.ConsoleColors;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;

/**
 * @author ANZO
 * @since 08.09.2016
 */
@Slf4j
public final class ConsoleUtils {
	/**
	 * Prints a named section to log.
	 * @param sectionName section name
	 */
	public static void printSection(@NotNull String sectionName) {
		log.info("{}[ {} ]", "-".repeat(Math.max(0, (120 - 3 - sectionName.length() - 2))), sectionName);
	}

	/**
	 * TODO: Implement custom RollingRandomAccessFile with replace ANSI codes when write to file to avoid unreadable symbols in text file
	 * Prints a named section to log.
	 * @param sectionName section name
	 * @param color section color
	 */
	public static void printSection(@NotNull String sectionName, @NotNull ConsoleColors color) {
		log.info("{}{}[ {} ]{}", "-".repeat(Math.max(0, (120 - 3 - sectionName.length() - 2))), color.color(), sectionName, ConsoleColors.Normal.color());
	}
}
