package host.anzo.commons.utils;

import java.nio.file.Path;

/**
 * @author ANZO
 * @since 6/12/2024
 */
public class PathUtils {
	/**
	 * Checks if a given sub-path is contained within a full path.
	 * @param fullPath the complete path to be checked
	 * @param subPath the sub-path to search for within the full path
	 * @return {@code true} if the sub-path is found within the full path, {@code false} otherwise
	 */
	public static boolean containsSubPath(Path fullPath, Path subPath) {
		if (fullPath == null || subPath == null) {
			return false;
		}

		final Path normalizedFullPath = fullPath.normalize();
		final Path normalizedSubPath = subPath.normalize();

		final int fullNamesCount = normalizedFullPath.getNameCount();
		final int subNamesCount = normalizedSubPath.getNameCount();

		if (fullNamesCount < subNamesCount) {
			return false;
		}

		for (int i = 0; i <= fullNamesCount - subNamesCount; i++) {
			boolean found = true;
			for (int j = 0; j < subNamesCount; j++) {
				if (!normalizedFullPath.getName(i + j).equals(normalizedSubPath.getName(j))) {
					found = false;
					break;
				}
			}
			if (found) {
				return true;
			}
		}
		return false;
	}
}