package host.anzo.core.webserver.utils;

import lombok.Builder;
import lombok.Singular;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author ANZO
 * @since 4/28/2023
 */
@Builder
public class PostRequest {
    @Singular private final Map<String, String> params;

    public String build() {
        final List<String> paramPairs = new ArrayList<>();
        for(Map.Entry<String, String> entry : params.entrySet()) {
            paramPairs.add(entry.getKey() + "=" + entry.getValue());
        }
        return String.join("&", paramPairs);
    }
}
