/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import host.anzo.core.service.HttpService;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkUtils.class);
    private static final Pattern VALID_IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static String EXTERNAL_IP = null;

    @Nullable
    public static String getExternalIP() {
        if (NetworkUtils.isValidIp(EXTERNAL_IP)) {
            return EXTERNAL_IP;
        }
        String ip = HttpService.getInstance().httpGet("https://api.ipify.org/");
        if (!NetworkUtils.isValidIp(ip)) {
            ip = HttpService.getInstance().httpGet("https://ipinfo.io/ip");
        }
        if (!NetworkUtils.isValidIp(ip)) {
            ip = HttpService.getInstance().httpGet("https://www.trackip.net/ip");
        }
        if (!NetworkUtils.isValidIp(ip)) {
            ip = HttpService.getInstance().httpGet("https://checkip.amazonaws.com/");
        }
        if (NetworkUtils.isValidIp(ip)) {
            EXTERNAL_IP = ip;
            return ip;
        }
        return null;
    }

    public static boolean isLocalAddress(@NotNull InetAddress address) {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(address) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static boolean isLocalAddress(@NotNull String address) {
        try {
            return NetworkUtils.isLocalAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isValidIp(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        return VALID_IPV4_PATTERN.matcher(ip).matches();
    }

    public static boolean isPortFree(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket(port, 0);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Port {} is already bind. Please free it and restart server.", (Object)port);
                return false;
            }
        }
        socket.close();
        return bl;
    }
}

