/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.core.service.ThreadPoolService;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class FileWatcherService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWatcherService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final WatchService watchService;
    private final Map<WatchKey, WatchedDirectory> watchKeys;
    private volatile boolean running = true;
    private final Map<Path, Long> lastModifiedMap = new ConcurrentHashMap<Path, Long>();

    private FileWatcherService() {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.watchKeys = new ConcurrentHashMap<WatchKey, WatchedDirectory>();
        this.startMonitoring();
    }

    public void registerDirectory(Path directory, FileWatchListener listener, String ... extensions) {
        this.registerDirectory(directory, listener, Arrays.asList(extensions));
    }

    public void registerDirectory(Path directory, final FileWatchListener listener, final List<String> extensions) {
        try {
            WatchedDirectory watchedDir = new WatchedDirectory(directory, listener, extensions);
            this.registerDirectoryRecursive(watchedDir);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) throws IOException {
                    FileWatcherService.this.registerDirectoryRecursive(new WatchedDirectory(dir, listener, extensions));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            log.error("Error registering directory {}", (Object)directory, (Object)e);
        }
    }

    private void registerDirectoryRecursive(@NotNull WatchedDirectory watchedDir) throws IOException {
        Path directory = watchedDir.path();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Path must be a directory: " + String.valueOf(directory));
        }
        WatchKey key = directory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchKeys.put(key, watchedDir);
    }

    public void unregisterListener(FileWatchListener listener) {
        this.watchKeys.values().removeIf(watchedDir -> watchedDir.listener() == listener);
    }

    private void startMonitoring() {
        ThreadPoolService.getInstance().submit(() -> {
            while (this.running) {
                try {
                    WatchKey key = this.watchService.take();
                    WatchedDirectory watchedDir = this.watchKeys.get(key);
                    if (watchedDir == null) continue;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        this.handleEvent(watchedDir, event);
                    }
                    if (key.reset()) continue;
                    this.watchKeys.remove(key);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ClosedWatchServiceException e) {
                    break;
                }
            }
        });
    }

    private void handleEvent(@NotNull WatchedDirectory watchedDir, @NotNull WatchEvent<?> event) {
        Path dir = watchedDir.path();
        Path fullPath = dir.resolve((Path)event.context());
        FileWatchListener listener = watchedDir.listener();
        if (!this.matchesExtension(fullPath, watchedDir.extensions())) {
            return;
        }
        WatchEvent.Kind<?> kind = event.kind();
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            if (Files.isDirectory(fullPath, new LinkOption[0])) {
                try {
                    this.registerDirectoryRecursive(new WatchedDirectory(fullPath, listener, watchedDir.extensions()));
                }
                catch (IOException e) {
                    this.notifyListener(listener, FileWatchEvent.error(e));
                }
            }
            this.notifyListener(listener, FileWatchEvent.created(fullPath));
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.lastModifiedMap.remove(fullPath);
            this.notifyListener(listener, FileWatchEvent.deleted(fullPath));
        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            long now = System.currentTimeMillis();
            Long lastEventTime = this.lastModifiedMap.get(fullPath);
            if (lastEventTime != null && now - lastEventTime < 1000L) {
                return;
            }
            this.lastModifiedMap.put(fullPath, now);
            this.notifyListener(listener, FileWatchEvent.modified(fullPath));
        } else if (kind == StandardWatchEventKinds.OVERFLOW) {
            this.notifyListener(listener, FileWatchEvent.overflow());
        }
    }

    private boolean matchesExtension(Path file, List<String> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return true;
        }
        String fileName = file.getFileName().toString();
        return extensions.stream().anyMatch(fileName::endsWith);
    }

    private void notifyListener(FileWatchListener listener, FileWatchEvent event) {
        ThreadPoolService.getInstance().submit(() -> {
            try {
                listener.onFileChanged(event);
            }
            catch (Exception e) {
                listener.onFileChanged(FileWatchEvent.error(e));
            }
        });
    }

    public void onShutdown() {
        this.running = false;
        try {
            this.watchService.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.watchKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FileWatcherService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    FileWatcherService actualValue = new FileWatcherService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (FileWatcherService)($value == instance ? null : $value);
    }

    public static interface FileWatchListener {
        public void onFileChanged(@NotNull FileWatchEvent var1);
    }

    private record WatchedDirectory(Path path, FileWatchListener listener, List<String> extensions) {
        private WatchedDirectory(Path path, FileWatchListener listener, List<String> extensions) {
            this.path = path;
            this.listener = listener;
            this.extensions = extensions != null ? extensions.stream().map(ext -> ext.startsWith(".") ? ext : "." + ext).collect(Collectors.toList()) : Collections.emptyList();
        }
    }

    public static class FileWatchEvent {
        private final FileWatchEventType type;
        private final Path path;
        private final Exception error;

        private FileWatchEvent(FileWatchEventType type, Path path, Exception error) {
            this.type = type;
            this.path = path;
            this.error = error;
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static FileWatchEvent created(Path path) {
            return new FileWatchEvent(FileWatchEventType.CREATED, path, null);
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static FileWatchEvent deleted(Path path) {
            return new FileWatchEvent(FileWatchEventType.DELETED, path, null);
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static FileWatchEvent modified(Path path) {
            return new FileWatchEvent(FileWatchEventType.MODIFIED, path, null);
        }

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static FileWatchEvent error(Exception e) {
            return new FileWatchEvent(FileWatchEventType.ERROR, null, e);
        }

        @Contract(value=" -> new", pure=true)
        @NotNull
        public static FileWatchEvent overflow() {
            return new FileWatchEvent(FileWatchEventType.OVERFLOW, null, null);
        }

        @Generated
        public FileWatchEventType getType() {
            return this.type;
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public Exception getError() {
            return this.error;
        }

        public static enum FileWatchEventType {
            CREATED,
            DELETED,
            MODIFIED,
            ERROR,
            OVERFLOW;

        }
    }
}

