/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.collection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IndexableHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final List<K> keyList = new ArrayList<K>();

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (!this.keyList.contains(key)) {
            this.keyList.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyList.clear();
        super.clear();
    }

    public List<K> getKeys() {
        return new ArrayList<K>(this.keyList);
    }

    public int getKeyIndex(K key) {
        return this.keyList.indexOf(key);
    }

    public K getKeyAt(int index) {
        if (this.keyList.size() > index && index >= 0) {
            return this.keyList.get(index);
        }
        return null;
    }

    public V getValueAt(int index) {
        K key = this.getKeyAt(index);
        if (key != null) {
            return this.get(key);
        }
        return null;
    }

    @Override
    public V remove(@NotNull Object key) {
        Object removedEntry = super.remove(key);
        this.keyList.clear();
        this.keyList.addAll(super.keySet());
        return removedEntry;
    }
}

