/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.threading;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ThreadPoolPriorityFactory
implements ThreadFactory {
    private final int priority;
    private final String name;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;

    public ThreadPoolPriorityFactory(String name, int priority) {
        this.priority = priority;
        this.name = name;
        this.group = new ThreadGroup(this.name);
    }

    @Override
    public Thread newThread(@NotNull Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.name + "-" + this.threadNumber.getAndIncrement());
        thread.setPriority(this.priority);
        return thread;
    }

    @Generated
    public ThreadGroup getGroup() {
        return this.group;
    }
}

