package host.anzo.commons.network.iprange;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;

/**
 * @author Aristo
 */
public class IP6Range implements IPRange {
    private final BigInteger baseAddress;
    private final BigInteger mask;

    public IP6Range(@NotNull String ipWithPrefix) throws IOException {
        String[] parts = ipWithPrefix.split("/");
        String baseAddress = parts[0];
        int prefixLength = Integer.parseInt(parts[1]);
        this.baseAddress = ipToBigInteger(InetAddress.getByName(baseAddress).getAddress());
        this.mask = BigInteger.valueOf(-1).shiftLeft(128 - prefixLength);
    }

    private BigInteger ipToBigInteger(byte[] ipAddress) {
        return new BigInteger(1, ipAddress);
    }

    @Override
    public boolean contains(@NotNull InetAddress address) {
        BigInteger ip = ipToBigInteger(address.getAddress());
        return ip.and(mask).equals(baseAddress.and(mask));
    }
}
