/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.emergency.memory.watchers;

import host.anzo.commons.emergency.memory.MemoryLeakDetector;
import host.anzo.core.config.EmergencyConfig;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.Notification;
import javax.management.NotificationListener;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolListener
implements NotificationListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"Memory");
    private final MemoryPoolMXBean pool;

    PoolListener(MemoryPoolMXBean pool) {
        this.pool = pool;
    }

    @Override
    public void handleNotification(@NotNull Notification notification, Object handback) {
        if (!notification.getType().equals("java.management.memory.threshold.exceeded") && !notification.getType().equals("java.management.memory.collection.threshold.exceeded")) {
            return;
        }
        MemoryUsage usage = this.pool.getUsage();
        long used = usage.getUsed();
        long max = usage.getMax();
        long percent = Math.round((double)used / (double)max * 100.0);
        log.warn("Critical memory usage {}% for {} pool. Usage: {}/{} mb.", new Object[]{percent, this.pool.getName(), used / 1024L / 1024L, max / 1024L / 1024L});
        if (percent > (long)EmergencyConfig.MEMORY_LEAK_DETECT_PERCENT) {
            MemoryLeakDetector.getInstance().onMemoryLeakDetected();
        }
    }
}

