/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.config;

import host.anzo.commons.annotations.config.ConfigComments;
import host.anzo.commons.annotations.config.ConfigFile;
import host.anzo.commons.annotations.config.ConfigProperty;
import java.util.ArrayList;
import java.util.List;

@ConfigFile(name="config/core/webserver.properties")
public class WebServerConfig {
    @ConfigComments(comment={"Enable webserver.", "Default: false"})
    @ConfigProperty(name="webserver.enable", value="false")
    public static boolean ENABLE;
    @ConfigComments(comment={"Enable WebSockets.", "Default: false"})
    @ConfigProperty(name="webserver.sockets.enable", value="false")
    public static boolean ENABLE_SOCKETS;
    @ConfigComments(comment={"Webserver debug (removing some webclient restrictions).", "Default: false"})
    @ConfigProperty(name="webserver.debug", value="false")
    public static boolean DEBUG;
    @ConfigComments(comment={"Enable client requests log.", "Default: false"})
    @ConfigProperty(name="webserver.enable.requests_log", value="false")
    public static boolean ENABLE_REQUESTS_LOG;
    @ConfigComments(comment={"Enable compression for ingame webserver.", "Default: true"})
    @ConfigProperty(name="webserver.enable.compression", value="true")
    public static boolean ENABLE_COMPRESSION;
    @ConfigComments(comment={"Enable HTTP2 for webserver.", "Default: false"})
    @ConfigProperty(name="webserver.enable.http2", value="false")
    public static boolean ENABLE_HTTP2;
    @ConfigComments(comment={"Enable SSL for webserver.", "Default: false"})
    @ConfigProperty(name="webserver.enable.ssl", value="false")
    public static boolean ENABLE_SSL;
    @ConfigComments(comment={"Path to SSL store in JKS format.", "To import origin certificate from CloudFlare to JKS:", "1. openssl req -new -newkey rsa:2048 -nodes -keyout [domain].key -out [domain].csr", "2. Send CSR to CloudFlare, get pem key and place to file [domain].pem", "3. openssl pkcs12 -export -in [domain].pem -inkey [domain].key -out [domain].p12 -name [domain]", "4. keytool -importkeystore -srckeystore [domain].p12 -srcstoretype PKCS12 -destkeystore [domain].jks -deststoretype JKS", "Default: ./data/store.jks"})
    @ConfigProperty(name="webserver.ssl.store.path", value="./data/store.jks")
    public static String SSL_STORE_PATH;
    @ConfigComments(comment={"Password for JKS store.", "Default: storepassword"})
    @ConfigProperty(name="webserver.ssl.store.password", value="storepassword")
    public static String SSL_STORE_PASSWORD;
    @ConfigComments(comment={"Webserver data path.", "Default: data/web/"})
    @ConfigProperty(name="webserver.data_path", value="data/web/")
    public static String DATA_PATH;
    @ConfigComments(comment={"Webserver port.", "Default: 8089"})
    @ConfigProperty(name="webserver.port", value="8089")
    public static int PORT;
    @ConfigComments(comment={"Minimum webserver thread's count.", "Default: 8"})
    @ConfigProperty(name="webserver.thread_count_min", value="8")
    public static int THREAD_COUNT_MIN;
    @ConfigComments(comment={"Maximum webserver thread's count.", "Default: 32"})
    @ConfigProperty(name="webserver.thread_count_max", value="32")
    public static int THREAD_COUNT_MAX;
    @ConfigComments(comment={"Webserver request timeout.", "Default: 30000"})
    @ConfigProperty(name="webserver.timeout", value="30000")
    public static int TIMEOUT;
    @ConfigComments(comment={"Enable request rate limiter.", "Default: true"})
    @ConfigProperty(name="webserver.enable.request_limiter", value="true")
    public static boolean ENABLE_REQUEST_LIMITER;
    @ConfigComments(comment={"Webserver max requests per second from one client.", "Default: 15"})
    @ConfigProperty(name="webserver.max_requests_per_second", value="15")
    public static int MAX_REQUESTS_PER_SECOND;
    @ConfigComments(comment={"Enabled to connect user agents (empty to disable).", "Default: "})
    @ConfigProperty(name="webserver.enabled.user_agents", value="")
    public static List<String> ENABLED_USER_AGENTS;
    @ConfigComments(comment={"Allow requests only from Cloudflare proxies.", "Default: false"})
    @ConfigProperty(name="webserver.allow_only_cloudflare_ips", value="false")
    public static boolean ALLOW_ONLY_CLOUDFLARE_IPS;
    @ConfigComments(comment={"List of Administrator IP addresses", "Default: "})
    @ConfigProperty(name="administrator.ip.addresses", value="")
    public static List<String> ADMINISTRATOR_IP_ADDRESSES;
    @ConfigComments(comment={"Enable ReCaptcha.", "Default: true"})
    @ConfigProperty(name="recaptcha.enable", value="true")
    public static boolean RECAPTCHA_ENABLE;
    @ConfigComments(comment={"Recaptcha public key.", "Default:"})
    @ConfigProperty(name="recaptcha.public_key", value="")
    public static String RECAPTCHA_PUBLIC_KEY;
    @ConfigComments(comment={"Recaptcha private key.", "Default:"})
    @ConfigProperty(name="recaptcha.private_key", value="")
    public static String RECAPTCHA_PRIVATE_KEY;
    @ConfigComments(comment={"Enable possibility to capture Java process traffic by Telerik Fiddler (ONLY for debug purposes at dev environment)", "Default: false"})
    @ConfigProperty(name="use.fiddler.proxy", value="false")
    public static boolean USE_FIDDLER_PROXY;
    @ConfigComments(comment={"Ignore SSL certificate errors when connecting by https protocol (need for sniffing HTTPS traffic at localhost)", "Default: false"})
    @ConfigProperty(name="ignore.ssl.certificate.errors", value="false")
    public static boolean IGNORE_SSL_CERTIFICATE_ERRORS;

    static {
        ENABLED_USER_AGENTS = new ArrayList<String>();
        ADMINISTRATOR_IP_ADDRESSES = new ArrayList<String>();
    }
}

