/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.InsightsResponse;
import com.maxmind.geoip2.record.Traits;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.collection.StatsSet;
import host.anzo.commons.utils.StringUtilsEx;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class GeoIpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoIpService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private WebServiceClient webServiceClient;
    private DatabaseReader databaseReader;

    private GeoIpService() {
        try {
            URL databaseUrl = this.getClass().getClassLoader().getResource("GeoLite2-City.mmdb");
            if (databaseUrl != null) {
                this.databaseReader = new DatabaseReader.Builder(databaseUrl.openStream()).build();
                log.info("Loaded [{}] database (build date: [{}])", (Object)this.databaseReader.getMetadata().getDatabaseType(), (Object)this.databaseReader.getMetadata().getBuildDate());
            } else {
                log.warn("Cannot find GeoLite2-City.mmdb in classpath.");
            }
            int maxMindAccountId = Integer.parseInt(System.getProperty("maxMindAccountId", "0"));
            String maxMindLicenseKey = System.getProperty("maxMindLicenseKey", "");
            if (maxMindAccountId != 0 && StringUtilsEx.isNoneEmpty((CharSequence[])new CharSequence[]{maxMindLicenseKey})) {
                this.webServiceClient = new WebServiceClient.Builder(Integer.parseInt(System.getProperty("maxMindAccountId", "0")), System.getProperty("maxMindLicenseKey", "")).build();
                log.info("Initialized MaxMind GeoIP web service client for accountId=[{}]", (Object)maxMindAccountId);
            }
        }
        catch (IOException e) {
            log.error("Error while loading Geo IP data", (Throwable)e);
        }
    }

    public CityResponse getCity(String ipAddress) {
        if (this.databaseReader == null) {
            return null;
        }
        try {
            return this.databaseReader.city(InetAddress.getByName(ipAddress));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCountryName(String ipAddress) {
        if (this.databaseReader == null) {
            return null;
        }
        try {
            return this.databaseReader.country(InetAddress.getByName(ipAddress)).getCountry().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public InsightsResponse getInsights(String ipAddress) {
        if (this.webServiceClient == null) {
            return null;
        }
        try {
            return this.webServiceClient.insights(InetAddress.getByName(ipAddress));
        }
        catch (Exception e) {
            return null;
        }
    }

    public StatsSet getInfo(String ipAddress, boolean full) {
        try {
            StatsSet set = new StatsSet(Object2ObjectLinkedOpenHashMap::new);
            InsightsResponse response = full ? this.getInsights(ipAddress) : this.getCity(ipAddress);
            set.putString("--- GeoIP Service ---", full ? "Full" : "Short");
            if (response != null) {
                set.putString("City", response.getCity().getName());
                set.putString("Country", response.getCountry().getName());
                set.putString("CountryCode", response.getCountry().getIsoCode());
                set.putBoolean("EuroUnion", response.getCountry().isInEuropeanUnion());
                set.putObject("AccuracyRadius", response.getLocation().getAccuracyRadius());
                set.putObject("Latitude", response.getLocation().getLatitude());
                set.putObject("Longitude", response.getLocation().getLongitude());
                set.putObject("Population", response.getLocation().getPopulationDensity());
                Traits traits = response.getTraits();
                if (traits instanceof Traits) {
                    Traits traits2 = traits;
                    set.putObject("Network", traits2.getNetwork());
                    set.putBoolean("PublicProxy", traits2.isPublicProxy());
                    set.putBoolean("AnonymousProxy", traits2.isAnonymousProxy());
                    set.putBoolean("SatelliteProvider", traits2.isSatelliteProvider());
                    if (full) {
                        set.putString("Domain", traits2.getDomain());
                        set.putString("ISP", traits2.getIsp());
                        set.putEnum("ConnectionType", (Enum<?>)traits2.getConnectionType());
                        set.putString("UserType", traits2.getUserType());
                        set.putObject("UserCount", traits2.getUserCount());
                        set.putString("Organization", traits2.getOrganization());
                        set.putObject("AutonomousSystemNumber", traits2.getAutonomousSystemNumber());
                        set.putString("AutonomousSystemOrganization", traits2.getAutonomousSystemOrganization());
                        set.putString("MobileCountryCode", traits2.getMobileCountryCode());
                        set.putString("MobileNetworkCode", traits2.getMobileNetworkCode());
                        set.putBoolean("Anonymous", traits2.isAnonymous());
                        set.putBoolean("AnonymousVpn", traits2.isAnonymousVpn());
                        set.putBoolean("HostingProvider", traits2.isHostingProvider());
                        set.putBoolean("ResidentialProxy", traits2.isResidentialProxy());
                        set.putBoolean("LegitimateProxy", traits2.isLegitimateProxy());
                        set.putBoolean("TorExitNode", traits2.isTorExitNode());
                        set.putObject("StaticIpScore", traits2.getStaticIpScore());
                    }
                }
            }
            return set;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static GeoIpService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    GeoIpService actualValue = new GeoIpService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (GeoIpService)($value == instance ? null : $value);
    }
}

