/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.startup;

import host.anzo.classindex.ClassIndex;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.enums.ConsoleColors;
import host.anzo.commons.enums.startup.EShutdownPriority;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.commons.utils.ClassUtils;
import host.anzo.commons.utils.ConsoleUtils;
import host.anzo.commons.utils.SystemdUtils;
import host.anzo.commons.versioning.Version;
import host.anzo.core.startup.IStartupLevel;
import host.anzo.core.startup.StartModule;
import host.anzo.core.startup.StartupInstance;
import host.anzo.core.startup.StartupMethodInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="BeforeStart")
public class StartupManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartupManager.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private long loadStartTime;
    private long loadEndTime;
    private boolean isStartupCompleted = false;
    private final AtomicBoolean isShutDowning = new AtomicBoolean(false);

    private StartupManager() {
        System.setProperty("org.jooq.no-tips", "true");
        System.setProperty("org.jooq.no-logo", "true");
        AnsiConsole.systemInstall();
        new File("./log/").mkdir();
        try {
            Version.getInstance().init(Class.forName(Thread.currentThread().getStackTrace()[4].getClassName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ConsoleUtils.printSection("System Information");
        log.info("Operating System: {} Build: {}, Arch: {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        log.info("Available CPU(s): {}", (Object)Runtime.getRuntime().availableProcessors());
        log.info("CPU Identifier: {}", (Object)System.getenv("PROCESSOR_IDENTIFIER"));
        log.info("JVM: {} Build: {}", (Object)System.getProperty("java.vm.name"), (Object)System.getProperty("java.runtime.version"));
    }

    /*
     * WARNING - void declaration
     */
    public <SL extends Enum<SL>> void startup(@NotNull Class<SL> sl) {
        this.loadStartTime = System.currentTimeMillis();
        StartupInstance<Object> startup = new StartupInstance<Object>();
        for (Class clazz : ClassIndex.getAnnotated(StartupComponent.class)) {
            void var6_12;
            StartupComponent startupAnnotation = clazz.getAnnotation(StartupComponent.class);
            Object var6_13 = null;
            try {
                SL SL = Enum.valueOf(sl, startupAnnotation.value());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var6_12 == null) continue;
            try {
                StartModule<void> module = new StartModule<void>(var6_12, clazz);
                startup.put(var6_12, module);
            }
            catch (Exception e) {
                log.error("Error while loading class [{}] with [{}] StartupLevel", new Object[]{clazz.getSimpleName(), startupAnnotation.value(), e});
            }
        }
        for (Enum enum_ : (Enum[])sl.getEnumConstants()) {
            List<StartModule<Enum>> modules = startup.get(enum_);
            if (modules == null) continue;
            for (StartModule<Enum> module : modules) {
                IStartupLevel otherStartupLevel;
                for (Map.Entry<String, List<StartupMethodInfo>> entry : module.getBeforeMethods().entrySet()) {
                    otherStartupLevel = (IStartupLevel)Enum.valueOf(sl, entry.getKey());
                    for (StartupMethodInfo method : entry.getValue()) {
                        otherStartupLevel.addBefore(method);
                    }
                }
                for (Map.Entry<String, List<StartupMethodInfo>> entry : module.getAfterMethods().entrySet()) {
                    otherStartupLevel = (IStartupLevel)Enum.valueOf(sl, entry.getKey());
                    for (StartupMethodInfo method : entry.getValue()) {
                        otherStartupLevel.addAfter(method);
                    }
                }
            }
        }
        for (Map.Entry entry : startup.getAll()) {
            ArrayList<StartModule> invalidModules = new ArrayList<StartModule>();
            List list = (List)entry.getValue();
            for (StartModule module : list) {
                Class[] dependency;
                Class<?> clazz = module.getClazz();
                for (Class dep : dependency = clazz.getAnnotation(StartupComponent.class).dependency()) {
                    Optional<StartModule> dependencyModule = list.stream().filter(m -> m.getClazz().getCanonicalName().equals(dep.getCanonicalName())).findAny();
                    if (dependencyModule.isPresent()) {
                        module.addDependency(dependencyModule.get());
                        continue;
                    }
                    invalidModules.add(module);
                    log.warn("Not found dependency ({}) for {} on {} start level.", new Object[]{dep.getCanonicalName(), clazz.getCanonicalName(), ((Enum)module.getStartLevel()).name()});
                }
            }
            list.removeAll(invalidModules);
        }
        for (Enum enum_ : (Enum[])sl.getEnumConstants()) {
            ConsoleUtils.printSection(enum_.name(), ConsoleColors.Cyan);
            IStartupLevel startupInterface = (IStartupLevel)((Object)enum_);
            startupInterface.runBeforeMethods();
            startupInterface.before();
            if (startup.levelExists(enum_)) {
                startup.runLevel(enum_);
            } else {
                log.warn("No services found with level [{}] in current server instance! Consider to remove it from StartupLevel routine.", (Object)enum_);
            }
            startupInterface.runAfterMethods();
            startupInterface.after();
        }
        this.isStartupCompleted = true;
        this.loadEndTime = System.currentTimeMillis();
        SystemdUtils.notifyReady();
        log.info("{}Server loaded in [{}] second(s){}", new Object[]{ConsoleColors.Cyan.color(), this.getStartupTime(TimeUnit.SECONDS), ConsoleColors.Normal.color()});
    }

    public void shutdown() {
        if (this.isShutDowning.compareAndSet(false, true)) {
            Map<EShutdownPriority, List<Class>> classes = ClassIndex.getAnnotated(StartupComponent.class).stream().filter(IShutdownable.class::isAssignableFrom).collect(Collectors.groupingBy(item -> {
                StartupComponent component = item.getAnnotation(StartupComponent.class);
                if (component != null) {
                    return component.shutdownPriority();
                }
                return EShutdownPriority.ORDINAL;
            }));
            for (EShutdownPriority shutdownPriority : EShutdownPriority.values()) {
                List<Class> classesByPriority = classes.get(shutdownPriority);
                if (classesByPriority == null) continue;
                for (Class clazz : classesByPriority) {
                    Object singletonObject = ClassUtils.singletonInstance(clazz);
                    if (singletonObject != null) {
                        IShutdownable shutdownable = (IShutdownable)singletonObject;
                        try {
                            log.info("Invoking [{}] onShutdown...", (Object)shutdownable.getClass().getSimpleName());
                            shutdownable.onShutdown();
                        }
                        catch (Exception e) {
                            log.error("Error while invoking [{}] onShutdown", (Object)shutdownable.getClass().getSimpleName(), (Object)e);
                        }
                        continue;
                    }
                    log.error("Can't find singleton for IShutdownable=[{}]", (Object)clazz.getSimpleName());
                }
            }
            log.info("Server shutdown routine complete!");
        }
    }

    public boolean isStartupCompleted() {
        return this.isStartupCompleted;
    }

    public boolean isShutDowning() {
        return this.isShutDowning.get();
    }

    public long getStartupTime(@NotNull TimeUnit timeUnit) {
        return timeUnit.convert(this.loadEndTime - this.loadStartTime, TimeUnit.MILLISECONDS);
    }

    public int getUptime(@NotNull TimeUnit timeUnit) {
        return (int)timeUnit.convert(System.currentTimeMillis() - this.loadStartTime, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static StartupManager getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    StartupManager actualValue = new StartupManager();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (StartupManager)($value == instance ? null : $value);
    }

    @Generated
    public long getLoadStartTime() {
        return this.loadStartTime;
    }

    @Generated
    public long getLoadEndTime() {
        return this.loadEndTime;
    }
}

