package host.anzo.commons.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author ANZO, Aristo
 * @since 2/6/2023
 */
@Slf4j
@SuppressWarnings("deprecation")
public class StringUtilsEx extends StringUtils {
	/**
	 * Remove all whitespaces/tabs and special symbols like   and ‬
	 * @param input input string
	 * @return trim string
	 */
	public static @NotNull String trimNBSP(@NotNull String input) {
		return input.trim().replaceAll("\u00A0", "").replaceAll("\u202C", "");
	}

	/**
	 * Check specified string for regex pattern matching
	 *
	 * @param string string to check
	 * @param regex regexp pattern string representation
	 * @return {@code true} if string matches a pattern, {@code false} otherwise
	 */
	public static boolean matches(String string, String regex) {
		Pattern pattern;
		try {
			pattern = Pattern.compile(regex);
		} catch (Exception e) {
			log.error("Failed to compile regexp: {}", regex, e);
			return false;
		}
		final Matcher regexp = pattern.matcher(string);
		return regexp.matches();
	}

	/**
	 * Check specified string for regex pattern matching
	 * @param string string to check
	 * @param pattern regex pattern
	 * @return {@code true} if string matches a pattern, {@code false} otherwise
	 */
	public static boolean matches(String string, @NotNull Pattern pattern) {
		return pattern.matcher(string).matches();
	}

	/**
	 * Replace matches found by specified regexp in string
	 *
	 * @param string input string
	 * @param regex regexp pattern string representation
	 * @param replacement string to replace with
	 * @return string with replacements
	 */
	public static String replaceRegexp(String string, String regex, String replacement) {
		Pattern pattern = null;
		try {
			pattern = Pattern.compile(regex);
		} catch (Exception e) {
			log.error("Failed to compile regexp: {}", regex, e);
		}
		if (pattern != null) {
			Matcher regexp = pattern.matcher(string);
			string = regexp.replaceAll(replacement);
		}
		return string;
	}
}