/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.threading;

import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.core.config.EmergencyConfig;
import java.lang.reflect.UndeclaredThrowableException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metric
public class RunnableWrapper
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunnableWrapper.class);
    private static final PropertyNode RUNNABLE_WRAPPER_METRICS = Metrics.create();
    private static final PropertyNode RUNNABLE_WRAPPER_METRICS_VIRTUAL = Metrics.create();
    private final Runnable _r;
    private final boolean _v;
    private final String _n;

    public RunnableWrapper(Runnable r) {
        this(r, false);
    }

    public RunnableWrapper(Runnable r, boolean virtual) {
        this(r, virtual, r.getClass().getSimpleName());
    }

    public RunnableWrapper(Runnable r, String name) {
        this(r, false, name);
    }

    public RunnableWrapper(Runnable r, boolean virtual, String name) {
        this._r = r;
        this._v = virtual;
        this._n = name != null ? name : r.getClass().getSimpleName();
    }

    @Override
    public void run() throws UndeclaredThrowableException {
        if (this._r != null) {
            try {
                if (EmergencyConfig.ENABLE_METRICS) {
                    long start = System.nanoTime();
                    this._r.run();
                    this.recordMetric(this._v ? RUNNABLE_WRAPPER_METRICS_VIRTUAL : RUNNABLE_WRAPPER_METRICS, this._n + "_time_ns", System.nanoTime() - start);
                } else {
                    this._r.run();
                }
            }
            catch (Throwable e) {
                this.recordMetric(this._v ? RUNNABLE_WRAPPER_METRICS_VIRTUAL : RUNNABLE_WRAPPER_METRICS, this._n + "_error");
                log.error("Error while running RunnableWrapper:", e);
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    @NotNull
    public static MetricResult getMetric() {
        MetricResult rw = new MetricResult();
        rw.setMetricGroupType(MetricGroupType.THREADPOOL);
        rw.setName("RunnableWrapper");
        rw.setData((String)RUNNABLE_WRAPPER_METRICS.render().get());
        return rw;
    }

    public static MetricResult getMetricVirtual() {
        MetricResult rwv = new MetricResult();
        rwv.setMetricGroupType(MetricGroupType.THREADPOOL);
        rwv.setName("RunnableWrapperVirtual");
        rwv.setData((String)RUNNABLE_WRAPPER_METRICS_VIRTUAL.render().get());
        return rwv;
    }

    private void recordMetric(PropertyNode metrics, String metricName, long value) {
        if (EmergencyConfig.ENABLE_METRICS) {
            metrics.record(Metrics.value((String)metricName, (long)value));
        }
    }

    private void recordMetric(PropertyNode metrics, String metricName) {
        if (EmergencyConfig.ENABLE_METRICS) {
            metrics.record(Metrics.happened((String)metricName));
        }
    }
}

