package host.anzo.commons.objectpool;

/**
 * @author Aristo
 * @since 3/15/2025
 */
public interface IObjectPool<T> {
	/**
	 * @return object from pool
	 */
	T borrowObject();
	/**
	 * Return object ot pool
	 * @param object object to return
	 */
	void returnObject(T object);
	/**
	 * @return object pool name
	 */
	String getName();

	/**
	 * Event called when server shutdown
	 */
	void onShutdown();
}