/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DateTimeUtils {
    public static final LocalDateTime MAX_SQL_DATE = LocalDateTime.of(2099, 1, 1, 0, 0, 0);
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static long toEpochMillis(@NotNull LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @NotNull
    public static String getInternationalTime(long millis) {
        return "[SYS: " + LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(dateFormatter) + "] / [EDT: " + LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.of("GMT-04:00")).format(dateFormatter) + "] / [CET: " + LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.of("GMT+02:00")).format(dateFormatter) + "]";
    }

    @NotNull
    public static String getInternationalTime() {
        return DateTimeUtils.getInternationalTime(System.currentTimeMillis());
    }

    @NotNull
    public static String getFormattedDateTime(@NotNull LocalDateTime localDateTime) {
        return localDateTime.format(dateFormatter);
    }

    public static boolean isSameDay(long date1, long date2) {
        LocalDateTime localDateTime1 = LocalDateTime.ofInstant(Instant.ofEpochMilli(date1), ZoneId.systemDefault());
        LocalDateTime localDateTime2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(date2), ZoneId.systemDefault());
        return localDateTime1.getDayOfYear() == localDateTime2.getDayOfYear();
    }

    public static int parseTimeSpan(@NotNull String timeSpan, TimeUnit unit) {
        String[] timeSpanData = timeSpan.split(":");
        if (timeSpanData.length == 3) {
            int resultSeconds = Integer.parseInt(timeSpanData[0]) * 3600;
            resultSeconds += Integer.parseInt(timeSpanData[1]) * 60;
            return (int)unit.convert(resultSeconds += Integer.parseInt(timeSpanData[2]), TimeUnit.SECONDS);
        }
        return -1;
    }

    public static String toTimeSpan(long seconds) {
        return String.format("%02d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    public static DayOfWeek parseDay(int day) {
        if (day == 0) {
            return DayOfWeek.SUNDAY;
        }
        return DayOfWeek.values()[day - 1];
    }

    public static LocalDateTime getLocalDateTime() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault());
    }

    public static LocalDateTime getLocalDateTime(long epochTime) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTime), ZoneId.systemDefault());
    }

    public static ZonedDateTime getZonedDateTime(long epochTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochTime), ZoneId.systemDefault());
    }

    public static LocalDate getLocalDate(long epochTime) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTime), ZoneId.systemDefault()).toLocalDate();
    }

    public static long getCurrentDayPassedTime(long timeInMillis, @NotNull TimeUnit timeUnit) {
        return timeUnit.convert(timeInMillis - DateTimeUtils.getLocalDate(timeInMillis).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli(), TimeUnit.MILLISECONDS);
    }

    public static long getCurrentDayHourTime(long timeInMillis, int hour) {
        return DateTimeUtils.getCurrentDayHourTime(timeInMillis, hour, 0);
    }

    public static long getCurrentDayHourTime(long timeInMillis, int hour, int minute) {
        return DateTimeUtils.getLocalDateTime(timeInMillis).withHour(0).withMinute(0).withSecond(0).plusHours(hour).plusMinutes(minute).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getCurrentMonthStartTime(long timeInMillis) {
        LocalDate localDate = DateTimeUtils.getLocalDate(timeInMillis);
        LocalDate currentMonthStartDay = LocalDate.of(localDate.getYear(), localDate.getMonth(), 1);
        return currentMonthStartDay.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getCurrentMonthStartTime() {
        return DateTimeUtils.getCurrentMonthStartTime(System.currentTimeMillis());
    }

    public static long getNextHourTime(long timeInMillis, int hour, int minute) {
        return DateTimeUtils.getNextHourTime(DateTimeUtils.getLocalDateTime(timeInMillis), hour, minute).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getNextHourTime(int hour, int minute) {
        return DateTimeUtils.getNextHourTime(System.currentTimeMillis(), hour, minute);
    }

    public static LocalDateTime getNextHourTime(@NotNull LocalDateTime dateTime, int hour, int minute) {
        LocalDateTime nextHour = dateTime.withHour(0).withMinute(0).withSecond(0).plusHours(hour).plusMinutes(minute);
        return nextHour.isBefore(dateTime) ? DateTimeUtils.getNextDayHourTime(dateTime, hour, minute) : nextHour;
    }

    public static long getNextHourTime(long timeInMillis, int hour) {
        return DateTimeUtils.getNextHourTime(timeInMillis, hour, 0);
    }

    public static long getNextHourTime(long timeInMillis) {
        LocalDateTime localDateTime = DateTimeUtils.getLocalDateTime(timeInMillis);
        return DateTimeUtils.getNextHourTime(timeInMillis, localDateTime.getHour() + 1, 0);
    }

    public static long getNextHourTime() {
        return DateTimeUtils.getNextHourTime(System.currentTimeMillis());
    }

    public static long getNextDayStartTime(long timeInMillis, DayOfWeek dayOfWeek) {
        return DateTimeUtils.getLocalDateTime(timeInMillis).with(TemporalAdjusters.next(dayOfWeek)).withHour(0).withMinute(0).withSecond(0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getNextDayStartTime(long timeInMillis) {
        return DateTimeUtils.getNextDayHourTime(timeInMillis, 0, 0);
    }

    public static long getNextDayStartTime() {
        return DateTimeUtils.getNextDayStartTime(System.currentTimeMillis());
    }

    public static long getNextDayHourTime(long timeInMillis, int hour) {
        return DateTimeUtils.getLocalDateTime(timeInMillis).withHour(0).withMinute(0).withSecond(0).plusDays(1L).plusHours(hour).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getNextDayHourTime(int hour) {
        return DateTimeUtils.getNextDayHourTime(System.currentTimeMillis(), hour);
    }

    public static long getNextDayHourTime(long timeInMillis, int hour, int minute) {
        return DateTimeUtils.getLocalDateTime(timeInMillis).withHour(0).withMinute(0).withSecond(0).plusDays(1L).plusHours(hour).plusMinutes(minute).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getNextDayHourTime(int hour, int minute) {
        return DateTimeUtils.getNextDayHourTime(System.currentTimeMillis(), hour, minute);
    }

    @NotNull
    public static LocalDateTime getNextDayHourTime(@NotNull LocalDateTime dateTime, int hour, int minute) {
        return dateTime.withHour(0).withMinute(0).withSecond(0).plusDays(1L).plusHours(hour).plusMinutes(minute);
    }

    public static long getNextMonthStartTime(long timeInMillis) {
        LocalDate localDate = DateTimeUtils.getLocalDate(timeInMillis);
        LocalDate nextMonthDay = LocalDate.of(localDate.getYear(), localDate.getMonth(), 1).plusMonths(1L);
        return nextMonthDay.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getNextMonthStartTime() {
        return DateTimeUtils.getNextMonthStartTime(System.currentTimeMillis());
    }

    public static long getTimeToNextDayStart(long timeInMillis, DayOfWeek dayOfWeek) {
        return Math.max(0L, DateTimeUtils.getNextDayStartTime(timeInMillis, dayOfWeek) - DateTimeUtils.getLocalDateTime(timeInMillis).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static long getTimeToNextDayStart(DayOfWeek dayOfWeek) {
        return DateTimeUtils.getTimeToNextDayStart(System.currentTimeMillis(), dayOfWeek);
    }

    public static long getTimeToNextDayStart(long timeInMillis) {
        return Math.max(0L, DateTimeUtils.getNextDayStartTime(timeInMillis) - DateTimeUtils.getLocalDateTime(timeInMillis).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static long getTimeToNextDayStart() {
        return DateTimeUtils.getTimeToNextDayStart(System.currentTimeMillis());
    }

    public static long getTimeTo(@NotNull LocalDateTime dateTime, @NotNull TimeUnit timeUnit) {
        return timeUnit.convert(Math.max(0L, dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()), TimeUnit.MILLISECONDS);
    }

    public static long getTimeToNextHour(int hour, int minute, @NotNull TimeUnit timeUnit) {
        return timeUnit.convert(Math.max(0L, DateTimeUtils.getNextHourTime(LocalDateTime.now(), hour, minute).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()), TimeUnit.MILLISECONDS);
    }
}

