/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.annotations.startup.Scheduled;
import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.model.enums.EFirewallType;
import host.anzo.commons.model.enums.ERestrictionType;
import host.anzo.commons.utils.DateTimeUtils;
import host.anzo.commons.utils.NetworkUtils;
import host.anzo.core.config.FirewallConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.jctools.maps.NonBlockingHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service")
public class FirewallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"Firewall");
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, Long> blockedIps = new NonBlockingHashMap();
    private final Map<String, Map<String, BurstRateLimiter>> connectionRateLimiters = new NonBlockingHashMap();

    private FirewallService() {
        this.flushSystemFirewall();
    }

    public boolean isAllowedAddress(@NotNull Class<?> clazz, String ip, @Nullable Integer sourcePort, int destPort, double allowedRequestsPerSecond, ERestrictionType restrictionType) {
        return this.isAllowedAddress(clazz.getSimpleName(), ip, sourcePort, destPort, allowedRequestsPerSecond, restrictionType);
    }

    public boolean isAllowedAddress(String className, String ip, @Nullable Integer sourcePort, int destPort, double allowedRequestsPerSecond, ERestrictionType restrictionType) {
        Map classLimiters;
        BurstRateLimiter ipLimiter;
        try {
            if (NetworkUtils.isLocalAddress(InetAddress.getByName(ip))) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.blockedIps.containsKey(ip)) {
            return false;
        }
        Object rateLimitKey = ip;
        if (sourcePort != null) {
            rateLimitKey = ip + ":" + sourcePort;
        }
        if (!(ipLimiter = (classLimiters = this.connectionRateLimiters.computeIfAbsent(className, k -> new NonBlockingHashMap())).computeIfAbsent(rateLimitKey, k -> new BurstRateLimiter(allowedRequestsPerSecond, allowedRequestsPerSecond))).tryAcquire()) {
            if (restrictionType == ERestrictionType.BAN) {
                this.addBlock(className, ip, sourcePort, destPort, FirewallConfig.FIREWALL_BAN_TIME, TimeUnit.MILLISECONDS);
            }
            classLimiters.remove(ip);
            return false;
        }
        return true;
    }

    public void addBlock(String className, String ip, @Nullable Integer sourcePort, int destPort, long banTime, TimeUnit banTimeUnit) {
        long unbanTime = 0L;
        if (FirewallConfig.FIREWALL_TYPE == EFirewallType.SYSTEM && SystemUtils.IS_OS_LINUX) {
            String firewallCommand = FirewallConfig.FIREWALL_SYSTEM_FIREWALL_RULE.replace("$ip", ip);
            try {
                Runtime.getRuntime().exec(firewallCommand.split(" "));
                unbanTime = -1L;
            }
            catch (IOException e) {
                log.error("Error while adding firewall rule for class=[{}] and ipAddress=[{}] (sourcePort=[{}])", new Object[]{className, ip, sourcePort == null ? "N/A" : sourcePort, e});
            }
        } else if (FirewallConfig.FIREWALL_TYPE == EFirewallType.INTERNAL) {
            unbanTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(banTime, banTimeUnit);
            this.blockedIps.put(ip, unbanTime);
        }
        if (unbanTime != 0L) {
            Object sourcePortInfo;
            Object object = sourcePortInfo = sourcePort == null ? "" : " (sourcePort=" + sourcePort + ")";
            if (unbanTime > 0L) {
                log.warn("Address ip=[{}]{} blocked by [{}] firewall at port [{}] until [{}]", new Object[]{ip, sourcePortInfo, className, destPort, DateTimeUtils.getLocalDateTime(unbanTime).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)});
            } else {
                log.warn("Address ip=[{}]{} blocked by [{}] firewall at port [{}] permanently", new Object[]{ip, sourcePortInfo, className, destPort});
            }
        }
    }

    public void removeBlock(String ipAddress) {
        this.blockedIps.remove(ipAddress);
    }

    public void clear() {
        this.blockedIps.clear();
    }

    public void flushSystemFirewall() {
        if (FirewallConfig.FIREWALL_TYPE == EFirewallType.SYSTEM && SystemUtils.IS_OS_LINUX) {
            for (String set : FirewallConfig.FIREWALL_FLUSHED_SETS_BEFORE_START) {
                String firewallCommand = "nft flush set inet filter " + set;
                try {
                    Runtime.getRuntime().exec(firewallCommand.split(" "));
                }
                catch (IOException e) {
                    log.error("Error while flushing firewall set [{}]", (Object)set, (Object)e);
                }
            }
        }
    }

    @Scheduled(period=1L, timeUnit=TimeUnit.MINUTES, runAfterServerStart=true)
    public void cleanupBans() {
        try {
            for (Map.Entry<String, Long> entry : this.blockedIps.entrySet()) {
                if (entry.getValue() >= System.currentTimeMillis()) continue;
                this.blockedIps.remove(entry.getKey());
            }
        }
        catch (Exception e) {
            log.error("Error while cleaning up firewall bans", (Throwable)e);
        }
        finally {
            this.connectionRateLimiters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FirewallService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    FirewallService actualValue = new FirewallService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (FirewallService)($value == instance ? null : $value);
    }

    public static class BurstRateLimiter {
        private final double maxBurst;
        private final double permitsPerMs;
        private double availablePermits;
        private long lastUpdateTime;

        public BurstRateLimiter(double permitsPerSecond, double maxBurst) {
            if (permitsPerSecond <= 0.0 || maxBurst <= 0.0) {
                throw new IllegalArgumentException("Rate and burst must be positive");
            }
            this.maxBurst = maxBurst;
            this.permitsPerMs = permitsPerSecond / 1000.0;
            this.availablePermits = maxBurst;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public synchronized boolean tryAcquire() {
            return this.tryAcquire(1.0);
        }

        public synchronized boolean tryAcquire(double permits) {
            if (permits <= 0.0) {
                throw new IllegalArgumentException("Permits must be positive");
            }
            this.refillPermits();
            if (this.availablePermits >= permits) {
                this.availablePermits -= permits;
                return true;
            }
            return false;
        }

        private void refillPermits() {
            long now = System.currentTimeMillis();
            double elapsedMs = now - this.lastUpdateTime;
            this.lastUpdateTime = now;
            this.availablePermits = Math.min(this.maxBurst, this.availablePermits + elapsedMs * this.permitsPerMs);
        }
    }
}

