/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.startup;

import host.anzo.commons.utils.ClassUtils;
import host.anzo.core.service.ThreadPoolService;
import host.anzo.core.startup.StartupMethodInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IStartupLevel {
    public static final Map<IStartupLevel, List<StartupMethodInfo>> beforeMethods = new HashMap<IStartupLevel, List<StartupMethodInfo>>();
    public static final Map<IStartupLevel, List<StartupMethodInfo>> afterMethods = new HashMap<IStartupLevel, List<StartupMethodInfo>>();

    default public void before() {
    }

    default public void after() {
    }

    default public void addBefore(StartupMethodInfo methodInfo) {
        beforeMethods.computeIfAbsent(this, k -> new ArrayList()).add(methodInfo);
    }

    default public void addAfter(StartupMethodInfo methodInfo) {
        afterMethods.computeIfAbsent(this, k -> new ArrayList()).add(methodInfo);
    }

    default public void runBeforeMethods() {
        for (StartupMethodInfo methodInfo : beforeMethods.getOrDefault(this, Collections.emptyList())) {
            if (methodInfo.isAsync()) {
                ThreadPoolService.getInstance().execute(() -> ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method()), "StartupInstance.runBeforeMethods()");
                continue;
            }
            ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method());
        }
    }

    default public void runAfterMethods() {
        for (StartupMethodInfo methodInfo : afterMethods.getOrDefault(this, Collections.emptyList())) {
            if (methodInfo.isAsync()) {
                ThreadPoolService.getInstance().execute(() -> ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method()), "StartupInstance.runAfterMethods()");
                continue;
            }
            ClassUtils.singletonInstanceMethod(methodInfo.clazz(), methodInfo.method());
        }
    }
}

