/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.webserver.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import host.anzo.commons.utils.IpUtils;
import host.anzo.commons.utils.JsonUtils;
import host.anzo.commons.utils.VMUtils;
import host.anzo.core.config.WebServerConfig;
import host.anzo.core.webserver.WebService;
import host.anzo.core.webserver.utils.JsonResultBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ModelAndView;
import spark.Request;
import spark.Response;
import spark.Spark;

public abstract class AWebArea {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"WebServer");

    public abstract void registerPaths();

    protected JsonResultBuilder jsonBuilder(Response response, int code) {
        return new JsonResultBuilder(response, code);
    }

    protected JsonResultBuilder jsonBuilder(Response response) {
        return this.jsonBuilder(response, 0);
    }

    protected <T> T jsonToObject(Request request, Class<T> clazz) throws JsonProcessingException {
        return JsonUtils.jsonToObject(request, clazz);
    }

    protected <T> T jsonToObject(String body, Class<T> clazz) throws JsonProcessingException {
        return JsonUtils.jsonToObject(body, clazz);
    }

    protected String dataToJson(Response response, Object data) {
        return JsonUtils.dataToJson(response, data);
    }

    protected String dataToJson(Object data) {
        return JsonUtils.dataToJson(data);
    }

    protected String error(@NotNull Response response) {
        response.redirect("/ErrorPage");
        Spark.halt();
        return null;
    }

    protected String error(@NotNull Response response, String title, String text) {
        response.redirect("/ErrorPage?title=" + title + "&text=" + text);
        Spark.halt();
        return null;
    }

    protected String errorDisabled(@NotNull Response response) {
        return this.error(response, "Error", "Area disabled by Administrator");
    }

    protected String maintenance(@NotNull Response response) {
        response.redirect("/Maintenance");
        Spark.halt();
        return null;
    }

    protected String render(Map<String, Object> model, String templatePath) {
        return this.render(Spark.modelAndView(model, (String)templatePath));
    }

    protected String render(Object model, String templatePath) {
        return this.render(Spark.modelAndView((Object)model, (String)templatePath));
    }

    private String render(ModelAndView modelAndView) {
        String renderResult = WebService.getInstance().getTemplateEngine().render(modelAndView);
        if (VMUtils.DEBUG) {
            renderResult = renderResult.replace(".min.css", ".css");
            renderResult = renderResult.replace(".min.js", ".js");
            renderResult = renderResult.replaceAll("(?i)ondragstart=\"return false;\"", "");
            renderResult = renderResult.replaceAll("(?i)onselectstart=\"return false;\"", "");
            renderResult = renderResult.replaceAll("(?i)oncontextmenu=\"return false\"", "");
        }
        return renderResult;
    }

    protected void redirectKeepAlive(@NotNull Response response, String location, int httpStatusCode) {
        response.raw().setStatus(httpStatusCode);
        response.raw().setHeader("Connection", "keep-alive");
        response.raw().setHeader("Cache-Control", "private");
        response.raw().setHeader("Location", location);
        try {
            response.raw().sendError(httpStatusCode);
        }
        catch (IOException e) {
            log.warn("Exception when trying to redirect permanently", (Throwable)e);
        }
    }

    protected boolean isAllowedAddress(Request request) {
        return WebService.getInstance().isAllowedAddress(this.getRealIp(request), request.port());
    }

    protected String getRealIp(@NotNull Request request) {
        return IpUtils.getRealIp(request);
    }

    protected boolean isAdministratorIP(@NotNull Request request) {
        return WebServerConfig.ADMINISTRATOR_IP_ADDRESSES.contains(this.getRealIp(request));
    }

    protected List<DiskFileItem> parseRequest(@NotNull Request request) {
        try {
            return WebService.getInstance().getFileUploadServlet().parseRequest(request.raw());
        }
        catch (FileUploadException e) {
            log.error("Error while parseRequest()", (Throwable)e);
            return null;
        }
    }
}

