/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.collection;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final ConcurrentMap<E, Object> map = new ConcurrentHashMap<E, Object>();
    private static final Object EMPTY_OBJECT = new Object();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, EMPTY_OBJECT) == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == EMPTY_OBJECT;
    }

    public boolean addIfAbsent(E o) {
        Object obj = this.map.putIfAbsent(o, EMPTY_OBJECT);
        return obj == null;
    }
}

