/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class LCIDUtils {
    private static final Map<Integer, Locale> lcid2localeMap = new HashMap<Integer, Locale>();

    @NotNull
    private static Locale parseLocale(String lcv) {
        StringTokenizer t = new StringTokenizer(lcv, "_");
        Locale.Builder builder = new Locale.Builder();
        builder.setLanguage(t.nextToken().toLowerCase());
        builder.setRegion(t.hasMoreTokens() ? t.nextToken().toUpperCase() : "");
        builder.setVariant(t.hasMoreTokens() ? t.nextToken() : "");
        return builder.build();
    }

    public static synchronized Locale lcid2locale(int lcid, Locale defLocale) {
        return lcid2localeMap.getOrDefault(lcid, defLocale);
    }

    static {
        lcid2localeMap.put(1025, LCIDUtils.parseLocale("ar_SA"));
        lcid2localeMap.put(1026, LCIDUtils.parseLocale("bg_BG"));
        lcid2localeMap.put(1027, LCIDUtils.parseLocale("ca_ES"));
        lcid2localeMap.put(1028, LCIDUtils.parseLocale("zh_TW"));
        lcid2localeMap.put(1029, LCIDUtils.parseLocale("cs_CZ"));
        lcid2localeMap.put(1030, LCIDUtils.parseLocale("da_DK"));
        lcid2localeMap.put(1031, LCIDUtils.parseLocale("de_DE"));
        lcid2localeMap.put(1032, LCIDUtils.parseLocale("el_GR"));
        lcid2localeMap.put(1033, LCIDUtils.parseLocale("en_US"));
        lcid2localeMap.put(1034, LCIDUtils.parseLocale("es_ES"));
        lcid2localeMap.put(1035, LCIDUtils.parseLocale("fi_FI"));
        lcid2localeMap.put(1036, LCIDUtils.parseLocale("fr_FR"));
        lcid2localeMap.put(1037, LCIDUtils.parseLocale("iw_IL"));
        lcid2localeMap.put(1038, LCIDUtils.parseLocale("hu_HU"));
        lcid2localeMap.put(1039, LCIDUtils.parseLocale("is_IS"));
        lcid2localeMap.put(1040, LCIDUtils.parseLocale("it_IT"));
        lcid2localeMap.put(1041, LCIDUtils.parseLocale("ja_JP"));
        lcid2localeMap.put(1042, LCIDUtils.parseLocale("ko_KR"));
        lcid2localeMap.put(1043, LCIDUtils.parseLocale("nl_NL"));
        lcid2localeMap.put(1044, LCIDUtils.parseLocale("no_NO"));
        lcid2localeMap.put(1045, LCIDUtils.parseLocale("pl_PL"));
        lcid2localeMap.put(1046, LCIDUtils.parseLocale("pt_BR"));
        lcid2localeMap.put(1047, LCIDUtils.parseLocale("rm_CH"));
        lcid2localeMap.put(1048, LCIDUtils.parseLocale("ro_RO"));
        lcid2localeMap.put(1049, LCIDUtils.parseLocale("ru_RU"));
        lcid2localeMap.put(1050, LCIDUtils.parseLocale("hr_HR"));
        lcid2localeMap.put(1051, LCIDUtils.parseLocale("sk_SK"));
        lcid2localeMap.put(1052, LCIDUtils.parseLocale("sq_AL"));
        lcid2localeMap.put(1053, LCIDUtils.parseLocale("sv_SE"));
        lcid2localeMap.put(1054, LCIDUtils.parseLocale("th_TH"));
        lcid2localeMap.put(1055, LCIDUtils.parseLocale("tr_TR"));
        lcid2localeMap.put(1056, LCIDUtils.parseLocale("ur_PK"));
        lcid2localeMap.put(1057, LCIDUtils.parseLocale("in_ID"));
        lcid2localeMap.put(1058, LCIDUtils.parseLocale("uk_UA"));
        lcid2localeMap.put(1059, LCIDUtils.parseLocale("be_BY"));
        lcid2localeMap.put(1060, LCIDUtils.parseLocale("sl_SI"));
        lcid2localeMap.put(1061, LCIDUtils.parseLocale("et_EE"));
        lcid2localeMap.put(1062, LCIDUtils.parseLocale("lv_LV"));
        lcid2localeMap.put(1063, LCIDUtils.parseLocale("lt_LT"));
        lcid2localeMap.put(1065, LCIDUtils.parseLocale("fa_IR"));
        lcid2localeMap.put(1066, LCIDUtils.parseLocale("vi_VN"));
        lcid2localeMap.put(1067, LCIDUtils.parseLocale("hy_AM"));
        lcid2localeMap.put(1068, LCIDUtils.parseLocale("az_AZ"));
        lcid2localeMap.put(1069, LCIDUtils.parseLocale("eu_ES"));
        lcid2localeMap.put(1071, LCIDUtils.parseLocale("mk_MK"));
        lcid2localeMap.put(1073, LCIDUtils.parseLocale("ts"));
        lcid2localeMap.put(1074, LCIDUtils.parseLocale("tn_BW"));
        lcid2localeMap.put(1076, LCIDUtils.parseLocale("xh"));
        lcid2localeMap.put(1077, LCIDUtils.parseLocale("zu"));
        lcid2localeMap.put(1078, LCIDUtils.parseLocale("af_ZA"));
        lcid2localeMap.put(1079, LCIDUtils.parseLocale("ka_GE"));
        lcid2localeMap.put(1080, LCIDUtils.parseLocale("fo_FO"));
        lcid2localeMap.put(1081, LCIDUtils.parseLocale("in_IN"));
        lcid2localeMap.put(1082, LCIDUtils.parseLocale("mt_MT"));
        lcid2localeMap.put(1084, LCIDUtils.parseLocale("gd_GB"));
        lcid2localeMap.put(1085, LCIDUtils.parseLocale("yi"));
        lcid2localeMap.put(1086, LCIDUtils.parseLocale("ms_MY"));
        lcid2localeMap.put(1087, LCIDUtils.parseLocale("kk_KZ"));
        lcid2localeMap.put(1089, LCIDUtils.parseLocale("sw_KE"));
        lcid2localeMap.put(1091, LCIDUtils.parseLocale("uz_UZ"));
        lcid2localeMap.put(1092, LCIDUtils.parseLocale("tt"));
        lcid2localeMap.put(1097, LCIDUtils.parseLocale("ta_IN"));
        lcid2localeMap.put(1102, LCIDUtils.parseLocale("mr_IN"));
        lcid2localeMap.put(1103, LCIDUtils.parseLocale("sa_IN"));
        lcid2localeMap.put(2049, LCIDUtils.parseLocale("ar_IQ"));
        lcid2localeMap.put(2052, LCIDUtils.parseLocale("zh_CN"));
        lcid2localeMap.put(2055, LCIDUtils.parseLocale("de_CH"));
        lcid2localeMap.put(2057, LCIDUtils.parseLocale("en_GB"));
        lcid2localeMap.put(2058, LCIDUtils.parseLocale("es_MX"));
        lcid2localeMap.put(2060, LCIDUtils.parseLocale("fr_BE"));
        lcid2localeMap.put(2064, LCIDUtils.parseLocale("it_CH"));
        lcid2localeMap.put(2066, LCIDUtils.parseLocale("ko_KR"));
        lcid2localeMap.put(2067, LCIDUtils.parseLocale("nl_BE"));
        lcid2localeMap.put(2068, LCIDUtils.parseLocale("nn_NO"));
        lcid2localeMap.put(2070, LCIDUtils.parseLocale("pt_PT"));
        lcid2localeMap.put(2072, LCIDUtils.parseLocale("ro_MD"));
        lcid2localeMap.put(2073, LCIDUtils.parseLocale("ru_MD"));
        lcid2localeMap.put(2074, LCIDUtils.parseLocale("sh_YU"));
        lcid2localeMap.put(2077, LCIDUtils.parseLocale("sv_FI"));
        lcid2localeMap.put(2092, LCIDUtils.parseLocale("az_AZ"));
        lcid2localeMap.put(2108, LCIDUtils.parseLocale("ga_IE"));
        lcid2localeMap.put(2110, LCIDUtils.parseLocale("ms_BN"));
        lcid2localeMap.put(2115, LCIDUtils.parseLocale("uz_UZ"));
        lcid2localeMap.put(3073, LCIDUtils.parseLocale("ar_EG"));
        lcid2localeMap.put(3076, LCIDUtils.parseLocale("zh_HK"));
        lcid2localeMap.put(3079, LCIDUtils.parseLocale("de_AT"));
        lcid2localeMap.put(3081, LCIDUtils.parseLocale("en_AU"));
        lcid2localeMap.put(3082, LCIDUtils.parseLocale("es_ES"));
        lcid2localeMap.put(3084, LCIDUtils.parseLocale("fr_CA"));
        lcid2localeMap.put(3098, LCIDUtils.parseLocale("sr_YU"));
        lcid2localeMap.put(4097, LCIDUtils.parseLocale("ar_LY"));
        lcid2localeMap.put(4100, LCIDUtils.parseLocale("zh_SG"));
        lcid2localeMap.put(4103, LCIDUtils.parseLocale("de_LU"));
        lcid2localeMap.put(4105, LCIDUtils.parseLocale("en_CA"));
        lcid2localeMap.put(4106, LCIDUtils.parseLocale("es_GT"));
        lcid2localeMap.put(4108, LCIDUtils.parseLocale("fr_CH"));
        lcid2localeMap.put(5121, LCIDUtils.parseLocale("ar_DZ"));
        lcid2localeMap.put(5124, LCIDUtils.parseLocale("zh_MO"));
        lcid2localeMap.put(5127, LCIDUtils.parseLocale("de_LI"));
        lcid2localeMap.put(5129, LCIDUtils.parseLocale("en_NZ"));
        lcid2localeMap.put(5130, LCIDUtils.parseLocale("es_CR"));
        lcid2localeMap.put(5132, LCIDUtils.parseLocale("fr_LU"));
        lcid2localeMap.put(6145, LCIDUtils.parseLocale("ar_MA"));
        lcid2localeMap.put(6153, LCIDUtils.parseLocale("en_IE"));
        lcid2localeMap.put(6154, LCIDUtils.parseLocale("es_PA"));
        lcid2localeMap.put(6156, LCIDUtils.parseLocale("fr_MC"));
        lcid2localeMap.put(7169, LCIDUtils.parseLocale("ar_TN"));
        lcid2localeMap.put(7177, LCIDUtils.parseLocale("en_ZA"));
        lcid2localeMap.put(7178, LCIDUtils.parseLocale("es_DO"));
        lcid2localeMap.put(8193, LCIDUtils.parseLocale("ar_OM"));
        lcid2localeMap.put(8201, LCIDUtils.parseLocale("en_JM"));
        lcid2localeMap.put(8202, LCIDUtils.parseLocale("es_VE"));
        lcid2localeMap.put(9217, LCIDUtils.parseLocale("ar_YE"));
        lcid2localeMap.put(9225, LCIDUtils.parseLocale("en"));
        lcid2localeMap.put(9226, LCIDUtils.parseLocale("es_CO"));
        lcid2localeMap.put(10241, LCIDUtils.parseLocale("ar_SY"));
        lcid2localeMap.put(10249, LCIDUtils.parseLocale("en_BZ"));
        lcid2localeMap.put(10250, LCIDUtils.parseLocale("es_PE"));
        lcid2localeMap.put(11265, LCIDUtils.parseLocale("ar_JO"));
        lcid2localeMap.put(11273, LCIDUtils.parseLocale("en_TT"));
        lcid2localeMap.put(11274, LCIDUtils.parseLocale("es_AR"));
        lcid2localeMap.put(12289, LCIDUtils.parseLocale("ar_LB"));
        lcid2localeMap.put(12297, LCIDUtils.parseLocale("en_ZW"));
        lcid2localeMap.put(12298, LCIDUtils.parseLocale("es_EC"));
        lcid2localeMap.put(13313, LCIDUtils.parseLocale("ar_KW"));
        lcid2localeMap.put(13321, LCIDUtils.parseLocale("en_PH"));
        lcid2localeMap.put(13322, LCIDUtils.parseLocale("es_CL"));
        lcid2localeMap.put(14337, LCIDUtils.parseLocale("ar_AE"));
        lcid2localeMap.put(14346, LCIDUtils.parseLocale("es_UY"));
        lcid2localeMap.put(15361, LCIDUtils.parseLocale("ar_BH"));
        lcid2localeMap.put(15370, LCIDUtils.parseLocale("es_PY"));
        lcid2localeMap.put(16385, LCIDUtils.parseLocale("ar_QA"));
        lcid2localeMap.put(16394, LCIDUtils.parseLocale("es_BO"));
        lcid2localeMap.put(17418, LCIDUtils.parseLocale("es_SV"));
        lcid2localeMap.put(18442, LCIDUtils.parseLocale("es_HN"));
        lcid2localeMap.put(19466, LCIDUtils.parseLocale("es_NI"));
        lcid2localeMap.put(20490, LCIDUtils.parseLocale("es_PR"));
    }
}

